/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docidsets;

import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.operator.dociditerators.AndDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.OrDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.RangelessBitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.RangelessBitmapDocIdSet;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public interface FilterBlockDocIdSet
extends BlockDocIdSet {
    public long getNumEntriesScannedInFilter();

    default public FilterBlockDocIdSet toNonScanDocIdSet() {
        BlockDocIdIterator docIdIterator = this.iterator();
        if (docIdIterator instanceof ScanBasedDocIdIterator || docIdIterator instanceof AndDocIdIterator || docIdIterator instanceof OrDocIdIterator) {
            int docId;
            RoaringBitmapWriter bitmapWriter = RoaringBitmapWriter.bufferWriter().runCompress(false).get();
            while ((docId = docIdIterator.next()) != Integer.MIN_VALUE) {
                bitmapWriter.add(docId);
            }
            return new RangelessBitmapDocIdSet((ImmutableRoaringBitmap)bitmapWriter.get());
        }
        if (docIdIterator instanceof RangelessBitmapDocIdIterator) {
            return new RangelessBitmapDocIdSet((RangelessBitmapDocIdIterator)docIdIterator);
        }
        if (docIdIterator instanceof BitmapDocIdIterator) {
            return new BitmapDocIdSet((BitmapDocIdIterator)docIdIterator);
        }
        return this;
    }
}

