/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.AndDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class AndFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_AND";
    private final List<BaseFilterOperator> _filterOperators;

    public AndFilterOperator(List<BaseFilterOperator> filterOperators) {
        this._filterOperators = filterOperators;
    }

    @Override
    protected FilterBlock getNextBlock() {
        Tracing.activeRecording().setNumChildren(this._filterOperators.size());
        ArrayList<FilterBlockDocIdSet> filterBlockDocIdSets = new ArrayList<FilterBlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            filterBlockDocIdSets.add(((FilterBlock)filterOperator.nextBlock()).getBlockDocIdSet());
        }
        return new FilterBlock(new AndDocIdSet(filterBlockDocIdSets));
    }

    @Override
    public boolean canOptimizeCount() {
        boolean allChildrenCanProduceBitmaps = true;
        for (BaseFilterOperator child : this._filterOperators) {
            allChildrenCanProduceBitmaps &= child.canProduceBitmaps();
        }
        return allChildrenCanProduceBitmaps;
    }

    @Override
    public int getNumMatchingDocs() {
        if (this._filterOperators.size() == 2) {
            return this._filterOperators.get(0).getBitmaps().andCardinality(this._filterOperators.get(1).getBitmaps());
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[this._filterOperators.size()];
        int i = 0;
        for (BaseFilterOperator child : this._filterOperators) {
            bitmaps[i++] = child.getBitmaps().reduce();
        }
        return BufferFastAggregation.andCardinality((ImmutableRoaringBitmap[])bitmaps);
    }

    @Override
    public List<Operator> getChildOperators() {
        return new ArrayList<Operator>(this._filterOperators);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }
}

