/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.Tracing;

public class AggregationGroupByOrderByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String EXPLAIN_NAME = "AGGREGATE_GROUPBY_ORDERBY";
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final TransformOperator _transformOperator;
    private final long _numTotalDocs;
    private final boolean _useStarTree;
    private final DataSchema _dataSchema;
    private final QueryContext _queryContext;
    private int _numDocsScanned = 0;

    public AggregationGroupByOrderByOperator(AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, TransformOperator transformOperator, long numTotalDocs, QueryContext queryContext, boolean useStarTree) {
        int i;
        this._aggregationFunctions = aggregationFunctions;
        this._groupByExpressions = groupByExpressions;
        this._transformOperator = transformOperator;
        this._numTotalDocs = numTotalDocs;
        this._useStarTree = useStarTree;
        this._queryContext = queryContext;
        int numGroupByExpressions = groupByExpressions.length;
        int numAggregationFunctions = aggregationFunctions.length;
        int numColumns = numGroupByExpressions + numAggregationFunctions;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (i = 0; i < numGroupByExpressions; ++i) {
            ExpressionContext groupByExpression = groupByExpressions[i];
            columnNames[i] = groupByExpression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._transformOperator.getResultMetadata(groupByExpression).getDataType());
        }
        for (i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            int index = numGroupByExpressions + i;
            columnNames[index] = aggregationFunction.getResultColumnName();
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._queryContext, this._groupByExpressions, this._transformOperator) : new DefaultGroupByExecutor(this._queryContext, this._groupByExpressions, this._transformOperator);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            groupByExecutor.process(transformBlock);
        }
        boolean numGroupsLimitReached = groupByExecutor.getNumGroups() >= this._queryContext.getNumGroupsLimit();
        Tracing.activeRecording().setNumGroups(this._queryContext.getNumGroupsLimit(), groupByExecutor.getNumGroups());
        int minGroupTrimSize = this._queryContext.getMinSegmentGroupTrimSize();
        if (this._queryContext.getOrderByExpressions() != null && minGroupTrimSize > 0) {
            int trimSize = GroupByUtils.getTableCapacity(this._queryContext.getLimit(), minGroupTrimSize);
            if (groupByExecutor.getNumGroups() > trimSize) {
                TableResizer tableResizer = new TableResizer(this._dataSchema, this._queryContext);
                Collection<IntermediateRecord> intermediateRecords = groupByExecutor.trimGroupByResult(trimSize, tableResizer);
                IntermediateResultsBlock resultsBlock = new IntermediateResultsBlock(this._aggregationFunctions, intermediateRecords, this._dataSchema, this._queryContext.isNullHandlingEnabled());
                resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
                return resultsBlock;
            }
        }
        IntermediateResultsBlock resultsBlock = new IntermediateResultsBlock(this._aggregationFunctions, groupByExecutor.getResult(), this._dataSchema, this._queryContext.isNullHandlingEnabled());
        resultsBlock.setNumGroupsLimitReached(numGroupsLimitReached);
        return resultsBlock;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        int i;
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(groupKeys:");
        if (this._groupByExpressions.length > 0) {
            stringBuilder.append(this._groupByExpressions[0].toString());
            for (i = 1; i < this._groupByExpressions.length; ++i) {
                stringBuilder.append(", ").append(this._groupByExpressions[i].toString());
            }
        }
        stringBuilder.append(", aggregations:");
        if (this._aggregationFunctions.length > 0) {
            stringBuilder.append(this._aggregationFunctions[0].toExplainString());
            for (i = 1; i < this._aggregationFunctions.length; ++i) {
                stringBuilder.append(", ").append(this._aggregationFunctions[i].toExplainString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

