/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;

public class EmptySelectionOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_EMPTY";
    private final DataSchema _dataSchema;
    private final ExecutionStatistics _executionStatistics;
    private final TransformOperator _transformOperator;

    public EmptySelectionOperator(IndexSegment indexSegment, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        int numExpressions = expressions.size();
        String[] columnNames = new String[numExpressions];
        this._transformOperator = transformOperator;
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = expressions.get(i);
            TransformResultMetadata expressionMetadata = this._transformOperator.getResultMetadata(expression);
            columnNames[i] = expression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._executionStatistics = new ExecutionStatistics(0L, 0L, 0L, indexSegment.getSegmentMetadata().getTotalDocs());
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        return new IntermediateResultsBlock(this._dataSchema, Collections.emptyList(), false);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._executionStatistics;
    }
}

