/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;

public class StreamingSelectionOnlyOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_STREAMING";
    private final IndexSegment _indexSegment;
    private final boolean _nullHandlingEnabled;
    private final TransformOperator _transformOperator;
    private final List<ExpressionContext> _expressions;
    private final BlockValSet[] _blockValSets;
    private final DataSchema _dataSchema;
    private final int _limit;
    private int _numDocsScanned = 0;

    public StreamingSelectionOnlyOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._transformOperator = transformOperator;
        this._expressions = expressions;
        int numExpressions = expressions.size();
        this._blockValSets = new BlockValSet[numExpressions];
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = expressions.get(i);
            TransformResultMetadata expressionMetadata = transformOperator.getResultMetadata(expression);
            columnNames[i] = expression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._limit = queryContext.getLimit();
    }

    @Override
    @Nullable
    protected IntermediateResultsBlock getNextBlock() {
        if (this._numDocsScanned >= this._limit) {
            return null;
        }
        TransformBlock transformBlock = (TransformBlock)this._transformOperator.nextBlock();
        if (transformBlock == null) {
            return null;
        }
        int numExpressions = this._expressions.size();
        for (int i = 0; i < numExpressions; ++i) {
            this._blockValSets[i] = transformBlock.getBlockValueSet(this._expressions.get(i));
        }
        RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(this._blockValSets);
        int numDocs = transformBlock.getNumDocs();
        int numDocsToReturn = Math.min(this._limit - this._numDocsScanned, numDocs);
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numDocsToReturn);
        for (int i = 0; i < numDocsToReturn; ++i) {
            rows.add(blockValueFetcher.getRow(i));
        }
        this._numDocsScanned += numDocs;
        return new IntermediateResultsBlock(this._dataSchema, rows, this._nullHandlingEnabled);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }
}

