/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class CastTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "cast";
    private TransformFunction _transformFunction;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for CAST transform function");
        }
        this._transformFunction = arguments.get(0);
        TransformFunction castFormatTransformFunction = arguments.get(1);
        if (castFormatTransformFunction instanceof LiteralTransformFunction) {
            String targetType;
            switch (targetType = ((LiteralTransformFunction)castFormatTransformFunction).getLiteral().toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    this._resultMetadata = INT_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "LONG": {
                    this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT": {
                    this._resultMetadata = FLOAT_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DOUBLE": {
                    this._resultMetadata = DOUBLE_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DECIMAL": 
                case "BIGDECIMAL": 
                case "BIG_DECIMAL": {
                    this._resultMetadata = BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "BOOLEAN": {
                    this._resultMetadata = BOOLEAN_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "TIMESTAMP": {
                    this._resultMetadata = TIMESTAMP_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING": 
                case "VARCHAR": {
                    this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "JSON": {
                    this._resultMetadata = JSON_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to cast expression to type - " + targetType);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid cast to type - " + castFormatTransformFunction.getName());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.INT) {
            return this._transformFunction.transformToIntValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null || this._intValuesSV.length < length) {
            this._intValuesSV = new int[length];
        }
        switch (resultStoredType) {
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.LONG) {
            return this._transformFunction.transformToLongValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._longValuesSV == null || this._longValuesSV.length < length) {
            this._longValuesSV = new long[length];
        }
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (long[])this._longValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (long[])this._longValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (long[])this._longValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (long[])this._longValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (long[])this._longValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null || this._floatValuesSV.length < length) {
            this._floatValuesSV = new float[length];
        }
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (float[])this._floatValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (float[])this._floatValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (float[])this._floatValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (float[])this._floatValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (float[])this._floatValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultStoredType = this._resultMetadata.getDataType().getStoredType();
        if (resultStoredType == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < length) {
            this._doubleValuesSV = new double[length];
        }
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (double[])this._doubleValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (double[])this._doubleValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (double[])this._doubleValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (double[])this._doubleValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (double[])this._doubleValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType dataType = this._resultMetadata.getDataType();
        FieldSpec.DataType resultStoredType = dataType.getStoredType();
        if (dataType == FieldSpec.DataType.BIG_DECIMAL) {
            return this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null || this._bigDecimalValuesSV.length < length) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
        int numDocs = projectionBlock.getNumDocs();
        switch (resultStoredType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (BigDecimal[])this._bigDecimalValuesSV, (int)numDocs);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (BigDecimal[])this._bigDecimalValuesSV, (int)numDocs);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (BigDecimal[])this._bigDecimalValuesSV, (int)numDocs);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (BigDecimal[])this._bigDecimalValuesSV, (int)numDocs);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copy((String[])stringValues, (BigDecimal[])this._bigDecimalValuesSV, (int)numDocs);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        FieldSpec.DataType resultStoredType = resultDataType.getStoredType();
        int length = projectionBlock.getNumDocs();
        if (resultStoredType == FieldSpec.DataType.STRING) {
            FieldSpec.DataType inputDataType = this._transformFunction.getResultMetadata().getDataType();
            if (inputDataType.getStoredType() != inputDataType) {
                if (this._stringValuesSV == null || this._stringValuesSV.length < length) {
                    this._stringValuesSV = new String[length];
                }
                if (inputDataType == FieldSpec.DataType.BOOLEAN) {
                    int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        this._stringValuesSV[i] = Boolean.toString(intValues[i] == 1);
                    }
                } else {
                    assert (inputDataType == FieldSpec.DataType.TIMESTAMP);
                    long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        this._stringValuesSV[i] = new Timestamp(longValues[i]).toString();
                    }
                }
                return this._stringValuesSV;
            }
            return this._transformFunction.transformToStringValuesSV(projectionBlock);
        }
        if (this._stringValuesSV == null || this._stringValuesSV.length < length) {
            this._stringValuesSV = new String[length];
        }
        switch (resultDataType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BOOLEAN: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._stringValuesSV[i] = Boolean.toString(intValues[i] == 1);
                }
                break;
            }
            case TIMESTAMP: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._stringValuesSV[i] = new Timestamp(longValues[i]).toString();
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._stringValuesSV;
    }
}

