/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class LiteralTransformFunction
implements TransformFunction {
    private final String _literal;
    private final FieldSpec.DataType _dataType;
    private final int _intLiteral;
    private final long _longLiteral;
    private final float _floatLiteral;
    private final double _doubleLiteral;
    private final BigDecimal _bigDecimalLiteral;
    private int[] _intResult;
    private long[] _longResult;
    private float[] _floatResult;
    private double[] _doubleResult;
    private BigDecimal[] _bigDecimalResult;
    private String[] _stringResult;
    private byte[][] _bytesResult;

    public LiteralTransformFunction(String literal) {
        this._literal = literal;
        this._dataType = LiteralTransformFunction.inferLiteralDataType(literal);
        this._bigDecimalLiteral = this._dataType.isNumeric() ? new BigDecimal(this._literal) : (this._dataType == FieldSpec.DataType.BOOLEAN ? PinotDataType.BOOLEAN.toBigDecimal((Object)Boolean.valueOf(literal)) : (this._dataType == FieldSpec.DataType.TIMESTAMP ? PinotDataType.TIMESTAMP.toBigDecimal((Object)Timestamp.valueOf(literal)) : BigDecimal.ZERO));
        this._intLiteral = this._bigDecimalLiteral.intValue();
        this._longLiteral = this._bigDecimalLiteral.longValue();
        this._floatLiteral = this._bigDecimalLiteral.floatValue();
        this._doubleLiteral = this._bigDecimalLiteral.doubleValue();
    }

    @VisibleForTesting
    static FieldSpec.DataType inferLiteralDataType(String literal) {
        try {
            Number number = NumberUtils.createNumber((String)literal);
            if (number instanceof Integer) {
                return FieldSpec.DataType.INT;
            }
            if (number instanceof Long) {
                return FieldSpec.DataType.LONG;
            }
            if (number instanceof Float) {
                return FieldSpec.DataType.FLOAT;
            }
            if (number instanceof Double) {
                return FieldSpec.DataType.DOUBLE;
            }
            if (number instanceof BigDecimal | number instanceof BigInteger) {
                return FieldSpec.DataType.BIG_DECIMAL;
            }
            return FieldSpec.DataType.STRING;
        }
        catch (Exception exception) {
            if (literal.equals("true") || literal.equals("false")) {
                return FieldSpec.DataType.BOOLEAN;
            }
            try {
                Timestamp.valueOf(literal);
                return FieldSpec.DataType.TIMESTAMP;
            }
            catch (Exception exception2) {
                return FieldSpec.DataType.STRING;
            }
        }
    }

    public String getLiteral() {
        return this._literal;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._dataType, true, false);
    }

    @Override
    public Dictionary getDictionary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        int[] intResult = this._intResult;
        if (intResult == null || intResult.length < numDocs) {
            intResult = new int[numDocs];
            if (this._dataType != FieldSpec.DataType.BOOLEAN) {
                if (this._intLiteral != 0) {
                    Arrays.fill(intResult, this._intLiteral);
                }
            } else {
                Arrays.fill(intResult, this._literal.equals("true") ? 1 : 0);
            }
            this._intResult = intResult;
        }
        return intResult;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        long[] longResult = this._longResult;
        if (longResult == null || longResult.length < numDocs) {
            longResult = new long[numDocs];
            if (this._dataType != FieldSpec.DataType.TIMESTAMP) {
                if (this._longLiteral != 0L) {
                    Arrays.fill(longResult, this._longLiteral);
                }
            } else {
                Arrays.fill(longResult, Timestamp.valueOf(this._literal).getTime());
            }
            this._longResult = longResult;
        }
        return longResult;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        float[] floatResult = this._floatResult;
        if (floatResult == null || floatResult.length < numDocs) {
            floatResult = new float[numDocs];
            if (this._floatLiteral != 0.0f) {
                Arrays.fill(floatResult, this._floatLiteral);
            }
            this._floatResult = floatResult;
        }
        return floatResult;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        double[] doubleResult = this._doubleResult;
        if (doubleResult == null || doubleResult.length < numDocs) {
            doubleResult = new double[numDocs];
            if (this._doubleLiteral != 0.0) {
                Arrays.fill(doubleResult, this._doubleLiteral);
            }
            this._doubleResult = doubleResult;
        }
        return doubleResult;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        Object[] bigDecimalResult = this._bigDecimalResult;
        if (bigDecimalResult == null || bigDecimalResult.length < numDocs) {
            bigDecimalResult = new BigDecimal[numDocs];
            Arrays.fill(bigDecimalResult, this._bigDecimalLiteral);
            this._bigDecimalResult = bigDecimalResult;
        }
        return bigDecimalResult;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        Object[] stringResult = this._stringResult;
        if (stringResult == null || stringResult.length < numDocs) {
            stringResult = new String[numDocs];
            Arrays.fill(stringResult, this._literal);
            this._stringResult = stringResult;
        }
        return stringResult;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        Object bytesResult = this._bytesResult;
        if (bytesResult == null || ((byte[][])bytesResult).length < numDocs) {
            bytesResult = new byte[numDocs][];
            Arrays.fill((Object[])bytesResult, BytesUtils.toBytes((String)this._literal));
            this._bytesResult = bytesResult;
        }
        return bytesResult;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }
}

