/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextContainsPredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.H3InclusionIndexFilterOperator;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.TextContainsFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.FSTBasedRegexpPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.NativeMutableTextIndex;
import org.apache.pinot.segment.local.segment.index.readers.text.NativeTextIndexReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class FilterPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final FilterContext _filter;
    private final List<Pair<Predicate, PredicateEvaluator>> _predicateEvaluators = new ArrayList<Pair<Predicate, PredicateEvaluator>>(4);

    public FilterPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this(indexSegment, queryContext, null);
    }

    public FilterPlanNode(IndexSegment indexSegment, QueryContext queryContext, @Nullable FilterContext filter) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._filter = filter;
    }

    public BaseFilterOperator run() {
        FilterContext filter;
        ThreadSafeMutableRoaringBitmap validDocIds = this._indexSegment.getValidDocIds();
        MutableRoaringBitmap validDocIdsSnapshot = validDocIds != null && !this._queryContext.isSkipUpsert() ? validDocIds.getMutableRoaringBitmap() : null;
        int numDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        FilterContext filterContext = filter = this._filter != null ? this._filter : this._queryContext.getFilter();
        if (filter != null) {
            BaseFilterOperator filterOperator = this.constructPhysicalOperator(filter, numDocs);
            if (validDocIdsSnapshot != null) {
                BitmapBasedFilterOperator validDocFilter = new BitmapBasedFilterOperator((ImmutableRoaringBitmap)validDocIdsSnapshot, false, numDocs);
                return FilterOperatorUtils.getAndFilterOperator(this._queryContext, Arrays.asList(filterOperator, validDocFilter), numDocs);
            }
            return filterOperator;
        }
        if (validDocIdsSnapshot != null) {
            return new BitmapBasedFilterOperator((ImmutableRoaringBitmap)validDocIdsSnapshot, false, numDocs);
        }
        return new MatchAllFilterOperator(numDocs);
    }

    public List<Pair<Predicate, PredicateEvaluator>> getPredicateEvaluators() {
        return this._predicateEvaluators;
    }

    private boolean canApplyH3IndexForDistanceCheck(Predicate predicate, FunctionContext function) {
        if (predicate.getType() != Predicate.Type.RANGE) {
            return false;
        }
        String functionName = function.getFunctionName();
        if (!functionName.equals("st_distance") && !functionName.equals("stdistance")) {
            return false;
        }
        List arguments = function.getArguments();
        if (arguments.size() != 2) {
            throw new BadQueryRequestException("Expect 2 arguments for function: ST_Distance");
        }
        String columnName = null;
        boolean findLiteral = false;
        for (ExpressionContext argument : arguments) {
            if (argument.getType() == ExpressionContext.Type.IDENTIFIER) {
                columnName = argument.getIdentifier();
                continue;
            }
            if (argument.getType() != ExpressionContext.Type.LITERAL) continue;
            findLiteral = true;
        }
        return columnName != null && this._indexSegment.getDataSource(columnName).getH3Index() != null && findLiteral;
    }

    private boolean canApplyH3IndexForInclusionCheck(Predicate predicate, FunctionContext function) {
        if (predicate.getType() != Predicate.Type.EQ) {
            return false;
        }
        String functionName = function.getFunctionName();
        if (!functionName.equals("stwithin") && !functionName.equals("stcontains")) {
            return false;
        }
        List arguments = function.getArguments();
        if (arguments.size() != 2) {
            throw new BadQueryRequestException("Expect 2 arguments for function: " + functionName);
        }
        if (functionName.equals("stwithin")) {
            if (((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER && ((ExpressionContext)arguments.get(1)).getType() == ExpressionContext.Type.LITERAL) {
                String columnName = ((ExpressionContext)arguments.get(0)).getIdentifier();
                return this._indexSegment.getDataSource(columnName).getH3Index() != null;
            }
            return false;
        }
        if (((ExpressionContext)arguments.get(1)).getType() == ExpressionContext.Type.IDENTIFIER && ((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.LITERAL) {
            String columnName = ((ExpressionContext)arguments.get(1)).getIdentifier();
            return this._indexSegment.getDataSource(columnName).getH3Index() != null;
        }
        return false;
    }

    private BaseFilterOperator constructPhysicalOperator(FilterContext filter, int numDocs) {
        switch (filter.getType()) {
            case AND: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, numDocs);
                    if (childFilterOperator.isResultEmpty()) {
                        return EmptyFilterOperator.getInstance();
                    }
                    if (childFilterOperator.isResultMatchingAll()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getAndFilterOperator(this._queryContext, childFilterOperators, numDocs);
            }
            case OR: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, numDocs);
                    if (childFilterOperator.isResultMatchingAll()) {
                        return new MatchAllFilterOperator(numDocs);
                    }
                    if (childFilterOperator.isResultEmpty()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getOrFilterOperator(this._queryContext, childFilterOperators, numDocs);
            }
            case NOT: {
                List childFilters = filter.getChildren();
                assert (childFilters.size() == 1);
                BaseFilterOperator childFilterOperator = this.constructPhysicalOperator((FilterContext)childFilters.get(0), numDocs);
                return FilterOperatorUtils.getNotFilterOperator(this._queryContext, childFilterOperator, numDocs);
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                    if (this.canApplyH3IndexForDistanceCheck(predicate, lhs.getFunction())) {
                        return new H3IndexFilterOperator(this._indexSegment, predicate, numDocs);
                    }
                    if (this.canApplyH3IndexForInclusionCheck(predicate, lhs.getFunction())) {
                        return new H3InclusionIndexFilterOperator(this._indexSegment, predicate, this._queryContext, numDocs);
                    }
                    return new ExpressionFilterOperator(this._indexSegment, predicate, numDocs);
                }
                String column = lhs.getIdentifier();
                DataSource dataSource = this._indexSegment.getDataSource(column);
                switch (predicate.getType()) {
                    case TEXT_CONTAINS: {
                        TextIndexReader textIndexReader = dataSource.getTextIndex();
                        if (!(textIndexReader instanceof NativeTextIndexReader) && !(textIndexReader instanceof NativeMutableTextIndex)) {
                            throw new UnsupportedOperationException("TEXT_CONTAINS is supported only on native text index");
                        }
                        return new TextContainsFilterOperator(textIndexReader, (TextContainsPredicate)predicate, numDocs);
                    }
                    case TEXT_MATCH: {
                        TextIndexReader textIndexReader = dataSource.getTextIndex();
                        Preconditions.checkState((textIndexReader != null ? 1 : 0) != 0, (String)"Cannot apply TEXT_MATCH on column: %s without text index", (Object)column);
                        if (textIndexReader instanceof NativeTextIndexReader || textIndexReader instanceof NativeMutableTextIndex) {
                            throw new UnsupportedOperationException("TEXT_MATCH is not supported on native text index");
                        }
                        return new TextMatchFilterOperator(textIndexReader, (TextMatchPredicate)predicate, numDocs);
                    }
                    case REGEXP_LIKE: {
                        PredicateEvaluator predicateEvaluator = dataSource.getFSTIndex() != null ? FSTBasedRegexpPredicateEvaluatorFactory.newFSTBasedEvaluator((RegexpLikePredicate)predicate, dataSource.getFSTIndex(), dataSource.getDictionary()) : PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType());
                        this._predicateEvaluators.add((Pair<Predicate, PredicateEvaluator>)Pair.of((Object)predicate, (Object)predicateEvaluator));
                        return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs, this._queryContext.isNullHandlingEnabled());
                    }
                    case JSON_MATCH: {
                        JsonIndexReader jsonIndex = dataSource.getJsonIndex();
                        Preconditions.checkState((jsonIndex != null ? 1 : 0) != 0, (String)"Cannot apply JSON_MATCH on column: %s without json index", (Object)column);
                        return new JsonMatchFilterOperator(jsonIndex, (JsonMatchPredicate)predicate, numDocs);
                    }
                    case IS_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), false, numDocs);
                        }
                        return EmptyFilterOperator.getInstance();
                    }
                    case IS_NOT_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), true, numDocs);
                        }
                        return new MatchAllFilterOperator(numDocs);
                    }
                }
                PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType());
                this._predicateEvaluators.add((Pair<Predicate, PredicateEvaluator>)Pair.of((Object)predicate, (Object)predicateEvaluator));
                return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs, this._queryContext.isNullHandlingEnabled());
            }
        }
        throw new IllegalStateException();
    }
}

