/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class NoDictionarySingleColumnGroupKeyGenerator
implements GroupKeyGenerator {
    private final ExpressionContext _groupByExpression;
    private final FieldSpec.DataType _storedType;
    private final Map _groupKeyMap;
    private final int _globalGroupIdUpperBound;
    private final boolean _nullHandlingEnabled;
    private Integer _groupIdForNullValue = null;
    private final boolean _isSingleValueExpression;
    private int _numGroups = 0;

    public NoDictionarySingleColumnGroupKeyGenerator(TransformOperator transformOperator, ExpressionContext groupByExpression, int numGroupsLimit, boolean nullHandlingEnabled) {
        this._groupByExpression = groupByExpression;
        this._storedType = transformOperator.getResultMetadata(this._groupByExpression).getDataType().getStoredType();
        this._groupKeyMap = this.createGroupKeyMap(this._storedType);
        this._globalGroupIdUpperBound = numGroupsLimit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._isSingleValueExpression = transformOperator.getResultMetadata(groupByExpression).isSingleValue();
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[] groupKeys) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.generateKeysForBlockNullHandlingEnabled(transformBlock, groupKeys, nullBitmap);
            return;
        }
        int numDocs = transformBlock.getNumDocs();
        switch (this._storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(doubleValues[i]);
                }
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = blockValSet.getBigDecimalValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(bigDecimalValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                for (int i = 0; i < numDocs; ++i) {
                    groupKeys[i] = this.getKeyForValue(new ByteArray(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedType);
            }
        }
    }

    public void generateKeysForBlockNullHandlingEnabled(TransformBlock transformBlock, int[] groupKeys, RoaringBitmap nullBitmap) {
        assert (nullBitmap != null);
        BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpression);
        int numDocs = transformBlock.getNumDocs();
        switch (this._storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = nullBitmap.contains(i) ? this.getKeyForNullValue() : this.getKeyForValue(intValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForNullValue());
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = nullBitmap.contains(i) ? this.getKeyForNullValue() : this.getKeyForValue(longValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForNullValue());
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = nullBitmap.contains(i) ? this.getKeyForNullValue() : this.getKeyForValue(floatValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForNullValue());
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = nullBitmap.contains(i) ? this.getKeyForNullValue() : this.getKeyForValue(doubleValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForNullValue());
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = blockValSet.getBigDecimalValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = this.getKeyForValue(nullBitmap.contains(i) ? null : bigDecimalValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForValue((BigDecimal)null));
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = this.getKeyForValue(nullBitmap.contains(i) ? null : stringValues[i]);
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForValue((String)null));
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                if (nullBitmap.getCardinality() < numDocs) {
                    for (int i = 0; i < numDocs; ++i) {
                        groupKeys[i] = this.getKeyForValue(nullBitmap.contains(i) ? null : new ByteArray(bytesValues[i]));
                    }
                    break;
                }
                if (numDocs <= 0) break;
                Arrays.fill(groupKeys, 0, numDocs, this.getKeyForValue((ByteArray)null));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedType);
            }
        }
    }

    private Map createGroupKeyMap(FieldSpec.DataType keyType) {
        switch (keyType) {
            case INT: {
                Int2IntOpenHashMap intMap = new Int2IntOpenHashMap();
                intMap.defaultReturnValue(-1);
                return intMap;
            }
            case LONG: {
                Long2IntOpenHashMap longMap = new Long2IntOpenHashMap();
                longMap.defaultReturnValue(-1);
                return longMap;
            }
            case FLOAT: {
                Float2IntOpenHashMap floatMap = new Float2IntOpenHashMap();
                floatMap.defaultReturnValue(-1);
                return floatMap;
            }
            case DOUBLE: {
                Double2IntOpenHashMap doubleMap = new Double2IntOpenHashMap();
                doubleMap.defaultReturnValue(-1);
                return doubleMap;
            }
            case BIG_DECIMAL: {
                Object2IntOpenHashMap bigDecimalMap = new Object2IntOpenHashMap();
                bigDecimalMap.defaultReturnValue(-1);
                return bigDecimalMap;
            }
            case STRING: {
                Object2IntOpenHashMap stringMap = new Object2IntOpenHashMap();
                stringMap.defaultReturnValue(-1);
                return stringMap;
            }
            case BYTES: {
                Object2IntOpenHashMap bytesMap = new Object2IntOpenHashMap();
                bytesMap.defaultReturnValue(-1);
                return bytesMap;
            }
        }
        throw new IllegalStateException("Illegal data type for no-dictionary key generator: " + keyType);
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[][] groupKeys) {
        block32: {
            BlockValSet blockValSet;
            int numDocs;
            block31: {
                numDocs = transformBlock.getNumDocs();
                blockValSet = transformBlock.getBlockValueSet(this._groupByExpression);
                if (!this._isSingleValueExpression) break block31;
                switch (this._storedType) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(intValues[i])};
                        }
                        break block32;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(longValues[i])};
                        }
                        break block32;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(floatValues[i])};
                        }
                        break block32;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(doubleValues[i])};
                        }
                        break block32;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(stringValues[i])};
                        }
                        break block32;
                    }
                    case BYTES: {
                        byte[][] byteValues = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < numDocs; ++i) {
                            groupKeys[i] = new int[]{this.getKeyForValue(new ByteArray(byteValues[i]))};
                        }
                        break block32;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedType);
                    }
                }
            }
            switch (this._storedType) {
                case INT: {
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int i = 0; i < numDocs; ++i) {
                        int mvSize = intValues[i].length;
                        int[] mvKeys = new int[mvSize];
                        for (int j = 0; j < mvSize; ++j) {
                            mvKeys[j] = this.getKeyForValue(intValues[i][j]);
                        }
                        groupKeys[i] = mvKeys;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int i = 0; i < numDocs; ++i) {
                        int mvSize = longValues[i].length;
                        int[] mvKeys = new int[mvSize];
                        for (int j = 0; j < mvSize; ++j) {
                            mvKeys[j] = this.getKeyForValue(longValues[i][j]);
                        }
                        groupKeys[i] = mvKeys;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < numDocs; ++i) {
                        int mvSize = floatValues[i].length;
                        int[] mvKeys = new int[mvSize];
                        for (int j = 0; j < mvSize; ++j) {
                            mvKeys[j] = this.getKeyForValue(floatValues[i][j]);
                        }
                        groupKeys[i] = mvKeys;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < numDocs; ++i) {
                        int mvSize = doubleValues[i].length;
                        int[] mvKeys = new int[mvSize];
                        for (int j = 0; j < mvSize; ++j) {
                            mvKeys[j] = this.getKeyForValue(doubleValues[i][j]);
                        }
                        groupKeys[i] = mvKeys;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (int i = 0; i < numDocs; ++i) {
                        int mvSize = stringValues[i].length;
                        int[] mvKeys = new int[mvSize];
                        for (int j = 0; j < mvSize; ++j) {
                            mvKeys[j] = this.getKeyForValue(stringValues[i][j]);
                        }
                        groupKeys[i] = mvKeys;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedType);
                }
            }
        }
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._groupKeyMap.size();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
        switch (this._storedType) {
            case INT: {
                return new IntGroupKeyIterator((Int2IntOpenHashMap)this._groupKeyMap, this._groupIdForNullValue);
            }
            case LONG: {
                return new LongGroupKeyIterator((Long2IntOpenHashMap)this._groupKeyMap, this._groupIdForNullValue);
            }
            case FLOAT: {
                return new FloatGroupKeyIterator((Float2IntOpenHashMap)this._groupKeyMap, this._groupIdForNullValue);
            }
            case DOUBLE: {
                return new DoubleGroupKeyIterator((Double2IntOpenHashMap)this._groupKeyMap, this._groupIdForNullValue);
            }
            case BIG_DECIMAL: 
            case STRING: 
            case BYTES: {
                return new ObjectGroupKeyIterator((Object2IntOpenHashMap)this._groupKeyMap);
            }
        }
        throw new IllegalStateException();
    }

    private int getKeyForNullValue() {
        if (this._groupIdForNullValue != null) {
            return this._groupIdForNullValue;
        }
        if (this._numGroups < this._globalGroupIdUpperBound) {
            this._groupIdForNullValue = this._numGroups++;
            return this._groupIdForNullValue;
        }
        return -1;
    }

    @Override
    public int getNumKeys() {
        return this._groupKeyMap.size();
    }

    private int getKeyForValue(int value) {
        Int2IntMap map = (Int2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(long value) {
        Long2IntMap map = (Long2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(float value) {
        Float2IntMap map = (Float2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(double value) {
        Double2IntMap map = (Double2IntMap)this._groupKeyMap;
        int groupId = map.get(value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put(value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(BigDecimal value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put((Object)value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(String value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put((Object)value, groupId);
        }
        return groupId;
    }

    private int getKeyForValue(ByteArray value) {
        Object2IntMap map = (Object2IntMap)this._groupKeyMap;
        int groupId = map.getInt((Object)value);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups++;
            map.put((Object)value, groupId);
        }
        return groupId;
    }

    private static class ObjectGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final ObjectIterator<Object2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;

        ObjectGroupKeyIterator(Object2IntOpenHashMap objectMap) {
            this._iterator = objectMap.object2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DoubleGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Double2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;
        Integer _groupKeyForNullValue;

        DoubleGroupKeyIterator(Double2IntOpenHashMap doubleMap, Integer groupKeyForNullValue) {
            this._iterator = doubleMap.double2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
            this._groupKeyForNullValue = groupKeyForNullValue;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext() || this._groupKeyForNullValue != null;
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            if (this._groupKeyForNullValue != null) {
                this._groupKey._groupId = this._groupKeyForNullValue;
                this._groupKey._keys = new Object[]{null};
                this._groupKeyForNullValue = null;
                return this._groupKey;
            }
            Double2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getDoubleKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FloatGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Float2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;
        Integer _groupKeyForNullValue;

        FloatGroupKeyIterator(Float2IntOpenHashMap floatMap, Integer groupKeyForNullValue) {
            this._iterator = floatMap.float2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
            this._groupKeyForNullValue = groupKeyForNullValue;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext() || this._groupKeyForNullValue != null;
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            if (this._groupKeyForNullValue != null) {
                this._groupKey._groupId = this._groupKeyForNullValue;
                this._groupKey._keys = new Object[]{null};
                this._groupKeyForNullValue = null;
                return this._groupKey;
            }
            Float2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{Float.valueOf(entry.getFloatKey())};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LongGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Long2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;
        Integer _groupKeyForNullValue;

        LongGroupKeyIterator(Long2IntOpenHashMap longMap, Integer groupKeyForNullValue) {
            this._iterator = longMap.long2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
            this._groupKeyForNullValue = groupKeyForNullValue;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext() || this._groupKeyForNullValue != null;
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            if (this._groupKeyForNullValue != null) {
                this._groupKey._groupId = this._groupKeyForNullValue;
                this._groupKey._keys = new Object[]{null};
                this._groupKeyForNullValue = null;
                return this._groupKey;
            }
            Long2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getLongKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntGroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        final Iterator<Int2IntMap.Entry> _iterator;
        final GroupKeyGenerator.GroupKey _groupKey;
        Integer _groupKeyForNullValue;

        IntGroupKeyIterator(Int2IntOpenHashMap intMap, Integer groupKeyForNullValue) {
            this._iterator = intMap.int2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
            this._groupKeyForNullValue = groupKeyForNullValue;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext() || this._groupKeyForNullValue != null;
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            if (this._groupKeyForNullValue != null) {
                this._groupKey._groupId = this._groupKeyForNullValue;
                this._groupKey._keys = new Object[]{null};
                this._groupKeyForNullValue = null;
                return this._groupKey;
            }
            Int2IntMap.Entry entry = this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = new Object[]{entry.getIntKey()};
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

