/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawIntSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawIntSingleColumnDistinctOrderByExecutor
extends BaseRawIntSingleColumnDistinctExecutor {
    private final IntPriorityQueue _priorityQueue;

    public RawIntSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new IntHeapPriorityQueue(Math.min(limit, 10000), (i1, i2) -> Integer.compare(i1, i2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        int numDocs = transformBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            int[] values = blockValueSet.getIntValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        this._hasNull = true;
                        continue;
                    }
                    this.add(values[i]);
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    this.add(values[i]);
                }
            }
        } else {
            int[][] values = blockValueSet.getIntValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (int value : values[i]) {
                    this.add(value);
                }
            }
        }
        return false;
    }

    private void add(int value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit - (this._hasNull ? 1 : 0)) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                int firstValue = this._priorityQueue.firstInt();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueInt();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
    }
}

