/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.executor;

import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.ExplainPlanRowData;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.pruner.SegmentPrunerService;
import org.apache.pinot.core.query.pruner.SegmentPrunerStatistics;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.util.QueryOptionsUtils;
import org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.trace.Tracing;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerQueryExecutorV1Impl
implements QueryExecutor {
    public static final String ENABLE_PREFETCH = "enable.prefetch";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueryExecutorV1Impl.class);
    private static final String IN_PARTITIONED_SUBQUERY = "inPartitionedSubquery";
    private InstanceDataManager _instanceDataManager;
    private ServerMetrics _serverMetrics;
    private SegmentPrunerService _segmentPrunerService;
    private PlanMaker _planMaker;
    private long _defaultTimeoutMs = 15000L;
    private boolean _enablePrefetch;

    @Override
    public synchronized void init(PinotConfiguration config, InstanceDataManager instanceDataManager, ServerMetrics serverMetrics) throws ConfigurationException {
        this._instanceDataManager = instanceDataManager;
        this._serverMetrics = serverMetrics;
        QueryExecutorConfig queryExecutorConfig = new QueryExecutorConfig(config);
        LOGGER.info("Trying to build SegmentPrunerService");
        this._segmentPrunerService = new SegmentPrunerService(queryExecutorConfig.getPrunerConfig());
        LOGGER.info("Trying to build QueryPlanMaker");
        this._planMaker = new InstancePlanMakerImplV2(queryExecutorConfig);
        if (queryExecutorConfig.getTimeOut() > 0L) {
            this._defaultTimeoutMs = queryExecutorConfig.getTimeOut();
        }
        this._enablePrefetch = Boolean.parseBoolean(config.getProperty(ENABLE_PREFETCH));
        LOGGER.info("Initialized query executor with defaultTimeoutMs: {}, enablePrefetch: {}", (Object)this._defaultTimeoutMs, (Object)this._enablePrefetch);
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Query executor started");
    }

    @Override
    public synchronized void shutDown() {
        LOGGER.info("Query executor shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTable processQuery(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        if (!queryRequest.isEnableTrace()) {
            return this.processQueryInternal(queryRequest, executorService, responseObserver);
        }
        try {
            Tracing.getTracer().register(queryRequest.getRequestId());
            DataTable dataTable = this.processQueryInternal(queryRequest, executorService, responseObserver);
            return dataTable;
        }
        finally {
            Tracing.getTracer().unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable processQueryInternal(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        TimerContext timerContext = queryRequest.getTimerContext();
        TimerContext.Timer schedulerWaitTimer = timerContext.getPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        if (schedulerWaitTimer != null) {
            schedulerWaitTimer.stopAndRecord();
        }
        TimerContext.Timer queryProcessingTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PROCESSING);
        long requestId = queryRequest.getRequestId();
        String tableNameWithType = queryRequest.getTableNameWithType();
        QueryContext queryContext = queryRequest.getQueryContext();
        LOGGER.debug("Incoming request Id: {}, query: {}", (Object)requestId, (Object)queryContext);
        long queryTimeoutMs = this._defaultTimeoutMs;
        Long timeoutFromQueryOptions = QueryOptionsUtils.getTimeoutMs(queryContext.getQueryOptions());
        if (timeoutFromQueryOptions != null) {
            queryTimeoutMs = timeoutFromQueryOptions;
        }
        long queryArrivalTimeMs = timerContext.getQueryArrivalTimeMs();
        long queryEndTimeMs = timerContext.getQueryArrivalTimeMs() + queryTimeoutMs;
        queryContext.setEndTimeMs(queryEndTimeMs);
        queryContext.setEnablePrefetch(this._enablePrefetch);
        long querySchedulingTimeMs = System.currentTimeMillis() - queryArrivalTimeMs;
        if (querySchedulingTimeMs >= queryTimeoutMs) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.SCHEDULING_TIMEOUT_EXCEPTIONS, 1L);
            String errorMessage = String.format("Query scheduling took %dms (longer than query timeout of %dms) on server: %s", querySchedulingTimeMs, queryTimeoutMs, this._instanceDataManager.getInstanceId());
            DataTable dataTable = DataTableFactory.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_SCHEDULING_TIMEOUT_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return dataTable;
        }
        TableDataManager tableDataManager = this._instanceDataManager.getTableDataManager(tableNameWithType);
        if (tableDataManager == null) {
            String errorMessage = String.format("Failed to find table: %s on server: %s", tableNameWithType, this._instanceDataManager.getInstanceId());
            DataTable dataTable = DataTableFactory.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.SERVER_TABLE_MISSING_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return dataTable;
        }
        List<String> segmentsToQuery = queryRequest.getSegmentsToQuery();
        ArrayList missingSegments = new ArrayList();
        List segmentDataManagers = tableDataManager.acquireSegments(segmentsToQuery, missingSegments);
        int numSegmentsAcquired = segmentDataManagers.size();
        ArrayList<IndexSegment> indexSegments = new ArrayList<IndexSegment>(numSegmentsAcquired);
        for (SegmentDataManager segmentDataManager : segmentDataManagers) {
            indexSegments.add(segmentDataManager.getSegment());
        }
        int numConsumingSegmentsQueried = 0;
        int numOnlineSegments = 0;
        long minIndexTimeMs = 0L;
        long minIngestionTimeMs = 0L;
        long maxEndTimeMs = 0L;
        if (tableDataManager instanceof RealtimeTableDataManager) {
            numConsumingSegmentsQueried = 0;
            numOnlineSegments = 0;
            minIndexTimeMs = Long.MAX_VALUE;
            minIngestionTimeMs = Long.MAX_VALUE;
            maxEndTimeMs = Long.MIN_VALUE;
            for (IndexSegment indexSegment : indexSegments) {
                SegmentMetadata segmentMetadata;
                if (indexSegment instanceof MutableSegment) {
                    long ingestionTimeMs;
                    ++numConsumingSegmentsQueried;
                    segmentMetadata = indexSegment.getSegmentMetadata();
                    long indexTimeMs = segmentMetadata.getLastIndexedTimestamp();
                    if (indexTimeMs != Long.MIN_VALUE && indexTimeMs < minIndexTimeMs) {
                        minIndexTimeMs = indexTimeMs;
                    }
                    if ((ingestionTimeMs = segmentMetadata.getLatestIngestionTimestamp()) == Long.MIN_VALUE || ingestionTimeMs >= minIngestionTimeMs) continue;
                    minIngestionTimeMs = ingestionTimeMs;
                    continue;
                }
                if (!(indexSegment instanceof ImmutableSegment)) continue;
                segmentMetadata = indexSegment.getSegmentMetadata();
                long indexCreationTime = segmentMetadata.getIndexCreationTime();
                ++numOnlineSegments;
                if (indexCreationTime != Long.MIN_VALUE) {
                    maxEndTimeMs = Math.max(maxEndTimeMs, indexCreationTime);
                    continue;
                }
                Interval timeInterval = segmentMetadata.getTimeInterval();
                if (timeInterval == null) continue;
                maxEndTimeMs = Math.max(maxEndTimeMs, timeInterval.getEndMillis());
            }
        }
        DataTable dataTable = null;
        try {
            dataTable = this.processQuery(indexSegments, queryContext, timerContext, executorService, responseObserver, queryRequest.isEnableStreaming());
        }
        catch (Exception e) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.QUERY_EXECUTION_EXCEPTIONS, 1L);
            if (e instanceof BadQueryRequestException) {
                LOGGER.info("Caught BadQueryRequestException while processing requestId: {}, {}", (Object)requestId, (Object)e.getMessage());
            } else {
                LOGGER.error("Exception processing requestId {}", (Object)requestId, (Object)e);
            }
            dataTable = DataTableFactory.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
            if (queryRequest.isEnableTrace() && TraceContext.traceEnabled() && dataTable != null) {
                dataTable.getMetadata().put(DataTable.MetadataKey.TRACE_INFO.getName(), TraceContext.getTraceInfo());
            }
        }
        queryProcessingTimer.stopAndRecord();
        long queryProcessingTime = queryProcessingTimer.getDurationMs();
        Map metadata = dataTable.getMetadata();
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName(), Integer.toString(numSegmentsAcquired));
        metadata.put(DataTable.MetadataKey.TIME_USED_MS.getName(), Long.toString(queryProcessingTime));
        int numMissingSegments = missingSegments.size();
        if (numMissingSegments != 0) {
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.SERVER_SEGMENT_MISSING_ERROR, (String)String.format("%d segments %s missing on server: %s", numMissingSegments, missingSegments, this._instanceDataManager.getInstanceId())));
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.NUM_MISSING_SEGMENTS, (long)numMissingSegments);
        }
        if (tableDataManager instanceof RealtimeTableDataManager) {
            long minConsumingFreshnessTimeMs = Long.MAX_VALUE;
            if (numConsumingSegmentsQueried > 0) {
                minConsumingFreshnessTimeMs = minIngestionTimeMs != Long.MAX_VALUE ? minIngestionTimeMs : minIndexTimeMs;
                metadata.put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_QUERIED.getName(), Integer.toString(numConsumingSegmentsQueried));
                metadata.put(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName(), Long.toString(minConsumingFreshnessTimeMs));
                LOGGER.debug("Request {} queried {} consuming segments with minConsumingFreshnessTimeMs: {}", new Object[]{requestId, numConsumingSegmentsQueried, minConsumingFreshnessTimeMs});
            } else if (numConsumingSegmentsQueried == 0 && maxEndTimeMs != Long.MIN_VALUE) {
                minConsumingFreshnessTimeMs = maxEndTimeMs;
                metadata.put(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName(), Long.toString(maxEndTimeMs));
                LOGGER.debug("Request {} queried {} consuming segments with minConsumingFreshnessTimeMs: {}", new Object[]{requestId, numConsumingSegmentsQueried, minConsumingFreshnessTimeMs});
            }
        }
        LOGGER.debug("Query processing time for request Id - {}: {}", (Object)requestId, (Object)queryProcessingTime);
        LOGGER.debug("InstanceResponse for request Id - {}: {}", (Object)requestId, (Object)dataTable);
        return dataTable;
    }

    private DataTable processQuery(List<IndexSegment> indexSegments, QueryContext queryContext, TimerContext timerContext, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver, boolean enableStreaming) throws Exception {
        this.handleSubquery(queryContext, indexSegments, timerContext, executorService);
        long numTotalDocs = 0L;
        for (IndexSegment indexSegment : indexSegments) {
            numTotalDocs += (long)indexSegment.getSegmentMetadata().getTotalDocs();
        }
        TimerContext.Timer segmentPruneTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.SEGMENT_PRUNING);
        int totalSegments = indexSegments.size();
        SegmentPrunerStatistics prunerStats = new SegmentPrunerStatistics();
        List<IndexSegment> selectedSegments = this._segmentPrunerService.prune(indexSegments, queryContext, prunerStats);
        segmentPruneTimer.stopAndRecord();
        int numSelectedSegments = selectedSegments.size();
        LOGGER.debug("Matched {} segments after pruning", (Object)numSelectedSegments);
        if (numSelectedSegments == 0) {
            DataTable dataTable = queryContext.isExplain() ? ServerQueryExecutorV1Impl.getExplainPlanResultsForNoMatchingSegment(totalSegments) : DataTableUtils.buildEmptyDataTable(queryContext);
            Map metadata = dataTable.getMetadata();
            metadata.put(DataTable.MetadataKey.TOTAL_DOCS.getName(), String.valueOf(numTotalDocs));
            metadata.put(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_MATCHED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_SERVER.getName(), String.valueOf(totalSegments));
            this.addPrunerStats(metadata, prunerStats);
            return dataTable;
        }
        TimerContext.Timer planBuildTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.BUILD_QUERY_PLAN);
        Plan queryPlan = enableStreaming ? this._planMaker.makeStreamingInstancePlan(selectedSegments, queryContext, executorService, responseObserver, this._serverMetrics) : this._planMaker.makeInstancePlan(selectedSegments, queryContext, executorService, this._serverMetrics);
        planBuildTimer.stopAndRecord();
        TimerContext.Timer planExecTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PLAN_EXECUTION);
        DataTable dataTable = queryContext.isExplain() ? ServerQueryExecutorV1Impl.processExplainPlanQueries(queryPlan) : queryPlan.execute();
        planExecTimer.stopAndRecord();
        Map metadata = dataTable.getMetadata();
        metadata.put(DataTable.MetadataKey.TOTAL_DOCS.getName(), Long.toString(numTotalDocs));
        int prunedSegments = totalSegments - numSelectedSegments;
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_SERVER.getName(), String.valueOf(prunedSegments));
        this.addPrunerStats(metadata, prunerStats);
        return dataTable;
    }

    private static DataTable getExplainPlanResultsForNoMatchingSegment(int totalNumSegments) {
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(DataSchema.EXPLAIN_RESULT_SCHEMA);
        try {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, String.format("PLAN_START(numSegmentsForThisPlan:%d)", totalNumSegments));
            dataTableBuilder.setColumn(1, -1);
            dataTableBuilder.setColumn(2, -1);
            dataTableBuilder.finishRow();
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, "ALL_SEGMENTS_PRUNED_ON_SERVER");
            dataTableBuilder.setColumn(1, 2);
            dataTableBuilder.setColumn(2, 1);
            dataTableBuilder.finishRow();
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to create EXPLAIN PLAN result table.", (Throwable)ioe);
        }
        return dataTableBuilder.build();
    }

    private static Map<Integer, List<ExplainPlanRows>> getAllSegmentsUniqueExplainPlanRowData(Operator root) {
        HashMap<Integer, List<ExplainPlanRows>> operatorDepthToRowDataMap = new HashMap<Integer, List<ExplainPlanRows>>();
        if (root == null) {
            return operatorDepthToRowDataMap;
        }
        HashMap uniquePlanNodeHashCodes = new HashMap();
        List<Operator> children = root.getChildOperators();
        for (Operator child : children) {
            int[] operatorId = new int[]{3};
            ExplainPlanRows explainPlanRows = new ExplainPlanRows();
            ServerQueryExecutorV1Impl.getSegmentExplainPlanRowData(child, explainPlanRows, operatorId, 2);
            int numRows = explainPlanRows.getExplainPlanRowData().size();
            if (numRows <= 0) continue;
            operatorDepthToRowDataMap.putIfAbsent(numRows, new ArrayList());
            uniquePlanNodeHashCodes.putIfAbsent(numRows, new HashSet());
            int explainPlanRowsHashCode = explainPlanRows.hashCode();
            if (!((HashSet)uniquePlanNodeHashCodes.get(numRows)).contains(explainPlanRowsHashCode)) {
                explainPlanRows.incrementNumSegmentsMatchingThisPlan();
                ((List)operatorDepthToRowDataMap.get(numRows)).add(explainPlanRows);
                ((HashSet)uniquePlanNodeHashCodes.get(numRows)).add(explainPlanRowsHashCode);
                continue;
            }
            boolean explainPlanMatchFound = false;
            int operatorDepthToRowMapSize = ((List)operatorDepthToRowDataMap.get(numRows)).size();
            for (int i = 0; i < operatorDepthToRowMapSize; ++i) {
                ExplainPlanRows explainPlanRowsPotentialMatch = (ExplainPlanRows)((List)operatorDepthToRowDataMap.get(numRows)).get(i);
                if (explainPlanRowsPotentialMatch.hashCode() != explainPlanRowsHashCode || !explainPlanRowsPotentialMatch.equals(explainPlanRows)) continue;
                explainPlanRowsPotentialMatch.incrementNumSegmentsMatchingThisPlan();
                explainPlanMatchFound = true;
                break;
            }
            if (explainPlanMatchFound) continue;
            explainPlanRows.incrementNumSegmentsMatchingThisPlan();
            ((List)operatorDepthToRowDataMap.get(numRows)).add(explainPlanRows);
        }
        return operatorDepthToRowDataMap;
    }

    private static void getSegmentExplainPlanRowData(Operator node, ExplainPlanRows explainPlanRows, int[] globalId, int parentId) {
        if (node == null) {
            return;
        }
        String explainPlanString = node.toExplainString();
        if (explainPlanString != null) {
            ExplainPlanRowData explainPlanRowData = new ExplainPlanRowData(explainPlanString, globalId[0], parentId);
            int n = globalId[0];
            globalId[0] = n + 1;
            parentId = n;
            explainPlanRows.appendExplainPlanRowData(explainPlanRowData);
            if (node instanceof EmptyFilterOperator) {
                explainPlanRows.setHasEmptyFilter(true);
            }
            if (node instanceof MatchAllFilterOperator) {
                explainPlanRows.setHasMatchAllFilter(true);
            }
        }
        List<Operator> children = node.getChildOperators();
        for (Operator child : children) {
            ServerQueryExecutorV1Impl.getSegmentExplainPlanRowData(child, explainPlanRows, globalId, parentId);
        }
    }

    public static DataTable processExplainPlanQueries(Plan queryPlan) {
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(DataSchema.EXPLAIN_RESULT_SCHEMA);
        List<Operator> childOperators = queryPlan.getPlanNode().run().getChildOperators();
        assert (childOperators.size() == 1);
        Operator root = childOperators.get(0);
        int numEmptyFilterSegments = 0;
        int numMatchAllFilterSegments = 0;
        try {
            Map<Integer, List<ExplainPlanRows>> operatorDepthToRowDataMap = ServerQueryExecutorV1Impl.getAllSegmentsUniqueExplainPlanRowData(root);
            ArrayList listOfExplainPlans = new ArrayList();
            operatorDepthToRowDataMap.forEach((key, value) -> listOfExplainPlans.addAll(value));
            ServerQueryExecutorV1Impl.setValueInDataTableBuilder(dataTableBuilder, root.toExplainString(), 2, 1);
            for (ExplainPlanRows explainPlanRows : listOfExplainPlans) {
                numEmptyFilterSegments += explainPlanRows.isHasEmptyFilter() ? explainPlanRows.getNumSegmentsMatchingThisPlan() : 0;
                numMatchAllFilterSegments += explainPlanRows.isHasMatchAllFilter() ? explainPlanRows.getNumSegmentsMatchingThisPlan() : 0;
                ServerQueryExecutorV1Impl.setValueInDataTableBuilder(dataTableBuilder, String.format("PLAN_START(numSegmentsForThisPlan:%d)", explainPlanRows.getNumSegmentsMatchingThisPlan()), -1, -1);
                for (ExplainPlanRowData explainPlanRowData : explainPlanRows.getExplainPlanRowData()) {
                    ServerQueryExecutorV1Impl.setValueInDataTableBuilder(dataTableBuilder, explainPlanRowData.getExplainPlanString(), explainPlanRowData.getOperatorId(), explainPlanRowData.getParentId());
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to create EXPLAIN PLAN result table.", (Throwable)ioe);
        }
        DataTable dataTable = dataTableBuilder.build();
        dataTable.getMetadata().put(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS.getName(), String.valueOf(numEmptyFilterSegments));
        dataTable.getMetadata().put(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS.getName(), String.valueOf(numMatchAllFilterSegments));
        return dataTable;
    }

    private static void setValueInDataTableBuilder(DataTableBuilder dataTableBuilder, String explainPlanString, int operatorId, int parentId) throws IOException {
        if (explainPlanString != null) {
            dataTableBuilder.startRow();
            dataTableBuilder.setColumn(0, explainPlanString);
            dataTableBuilder.setColumn(1, operatorId);
            dataTableBuilder.setColumn(2, parentId);
            dataTableBuilder.finishRow();
        }
    }

    private void handleSubquery(QueryContext queryContext, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService) throws Exception {
        FilterContext filter = queryContext.getFilter();
        if (filter != null) {
            this.handleSubquery(filter, indexSegments, timerContext, executorService, queryContext.getEndTimeMs());
        }
    }

    private void handleSubquery(FilterContext filter, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        List children = filter.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                this.handleSubquery(child, indexSegments, timerContext, executorService, endTimeMs);
            }
        } else {
            this.handleSubquery(filter.getPredicate().getLhs(), indexSegments, timerContext, executorService, endTimeMs);
        }
    }

    private void handleSubquery(ExpressionContext expression, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        FunctionContext function = expression.getFunction();
        if (function == null) {
            return;
        }
        List arguments = function.getArguments();
        if (StringUtils.remove((String)function.getFunctionName(), (char)'_').equalsIgnoreCase(IN_PARTITIONED_SUBQUERY)) {
            Preconditions.checkState((arguments.size() == 2 ? 1 : 0) != 0, (Object)"IN_PARTITIONED_SUBQUERY requires 2 arguments: expression, subquery");
            ExpressionContext subqueryExpression = (ExpressionContext)arguments.get(1);
            Preconditions.checkState((subqueryExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Second argument of IN_PARTITIONED_SUBQUERY must be a literal (subquery)");
            QueryContext subquery = QueryContextConverterUtils.getQueryContext(subqueryExpression.getLiteral());
            AggregationFunction[] aggregationFunctions = subquery.getAggregationFunctions();
            Preconditions.checkState((aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.IDSET && subquery.getGroupByExpressions() == null ? 1 : 0) != 0, (String)"Subquery in IN_PARTITIONED_SUBQUERY should be an ID_SET aggregation only query, found: %s", (Object)subqueryExpression.getLiteral());
            subquery.setEndTimeMs(endTimeMs);
            DataTable dataTable = this.processQuery(new ArrayList<IndexSegment>(indexSegments), subquery, timerContext, executorService, null, false);
            IdSet idSet = (IdSet)dataTable.getObject(0, 0);
            String serializedIdSet = idSet.toBase64String();
            function.setFunctionName(TransformFunctionType.INIDSET.name());
            arguments.set(1, ExpressionContext.forLiteral((String)serializedIdSet));
        } else {
            for (ExpressionContext argument : arguments) {
                this.handleSubquery(argument, indexSegments, timerContext, executorService, endTimeMs);
            }
        }
    }

    private void addPrunerStats(Map<String, String> metadata, SegmentPrunerStatistics prunerStats) {
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_INVALID.getName(), String.valueOf(prunerStats.getInvalidSegments()));
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_LIMIT.getName(), String.valueOf(prunerStats.getLimitPruned()));
        metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_VALUE.getName(), String.valueOf(prunerStats.getValuePruned()));
    }
}

