/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.HavingFilterHandler;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.roaringbitmap.RoaringBitmap;

public class GroupByDataTableReducer
implements DataTableReducer {
    private static final int MIN_DATA_TABLES_FOR_CONCURRENT_REDUCE = 2;
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final List<ExpressionContext> _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int _numColumns;

    GroupByDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        this._groupByExpressions = queryContext.getGroupByExpressions();
        assert (this._groupByExpressions != null);
        this._numGroupByExpressions = this._groupByExpressions.size();
        this._numColumns = this._numAggregationFunctions + this._numGroupByExpressions;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        assert (dataSchema != null);
        try {
            this.reduceToResultTable(brokerResponseNative, dataSchema, dataTableMap.values(), reducerContext, tableName, brokerMetrics);
            if (brokerMetrics != null) {
                brokerMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)BrokerMeter.GROUP_BY_SIZE, (long)brokerResponseNative.getResultTable().getRows().size());
            }
        }
        catch (TimeoutException e) {
            brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
        }
    }

    private void reduceToResultTable(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext, String rawTableName, BrokerMetrics brokerMetrics) throws TimeoutException {
        ArrayList<Object[]> rows;
        Iterator<Object> sortedIterator;
        int numRecords;
        if (!dataTables.isEmpty()) {
            IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
            if (brokerMetrics != null) {
                brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.NUM_RESIZES, (long)indexedTable.getNumResizes());
                brokerMetrics.addValueToTableGauge(rawTableName, (AbstractMetrics.Gauge)BrokerGauge.RESIZE_TIME_MS, indexedTable.getResizeTimeMs());
            }
            numRecords = indexedTable.size();
            sortedIterator = indexedTable.iterator();
        } else {
            numRecords = 0;
            sortedIterator = Collections.emptyIterator();
        }
        DataSchema prePostAggregationDataSchema = this.getPrePostAggregationDataSchema(dataSchema);
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, prePostAggregationDataSchema);
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        int limit = this._queryContext.getLimit();
        if (numRecords == 0 || limit == 0) {
            brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, Collections.emptyList()));
            return;
        }
        DataSchema.ColumnDataType[] columnDataTypes = prePostAggregationDataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        FilterContext havingFilter = this._queryContext.getHavingFilter();
        if (havingFilter != null) {
            rows = new ArrayList<Object[]>();
            HavingFilterHandler havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler, this._queryContext.isNullHandlingEnabled());
            while (rows.size() < limit && sortedIterator.hasNext()) {
                Object[] row = ((Record)sortedIterator.next()).getValues();
                this.extractFinalAggregationResults(row);
                for (int i = 0; i < numColumns; ++i) {
                    Object value = row[i];
                    if (value == null) continue;
                    row[i] = columnDataTypes[i].convert(row[i]);
                }
                if (!havingFilterHandler.isMatch(row)) continue;
                rows.add(row);
            }
        } else {
            int numRows = Math.min(numRecords, limit);
            rows = new ArrayList(numRows);
            for (int i = 0; i < numRows; ++i) {
                Object[] row = ((Record)sortedIterator.next()).getValues();
                this.extractFinalAggregationResults(row);
                for (int j = 0; j < numColumns; ++j) {
                    Object value = row[j];
                    if (value == null) continue;
                    row[j] = columnDataTypes[j].convert(row[j]);
                }
                rows.add(row);
            }
        }
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(rows.size());
        DataSchema.ColumnDataType[] resultColumnDataTypes = resultDataSchema.getColumnDataTypes();
        int numResultColumns = resultColumnDataTypes.length;
        for (Object[] row : rows) {
            Object[] resultRow = postAggregationHandler.getResult(row);
            for (int i = 0; i < numResultColumns; ++i) {
                Object value = resultRow[i];
                if (value == null) continue;
                resultRow[i] = resultColumnDataTypes[i].format(value);
            }
            resultRows.add(resultRow);
        }
        brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, resultRows));
    }

    private void extractFinalAggregationResults(Object[] row) {
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            int valueIndex = i + this._numGroupByExpressions;
            row[valueIndex] = this._aggregationFunctions[i].extractFinalResult(row[valueIndex]);
        }
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        System.arraycopy(dataSchema.getColumnDataTypes(), 0, columnDataTypes, 0, this._numGroupByExpressions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            columnDataTypes[i + this._numGroupByExpressions] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private IndexedTable getIndexedTable(DataSchema dataSchema, Collection<DataTable> dataTablesToReduce, DataTableReducerContext reducerContext) throws TimeoutException {
        int i;
        long start = System.currentTimeMillis();
        int numDataTables = dataTablesToReduce.size();
        int numReduceThreadsToUse = this.getNumReduceThreadsToUse(numDataTables, reducerContext.getMaxReduceThreadsPerQuery());
        int limit = this._queryContext.getLimit();
        int trimSize = GroupByUtils.getTableCapacity(limit);
        int resultSize = this._queryContext.getHavingFilter() != null ? trimSize : limit;
        int trimThreshold = reducerContext.getGroupByTrimThreshold();
        final IndexedTable indexedTable = numReduceThreadsToUse == 1 ? new SimpleIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold) : (trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, this._queryContext, resultSize) : new ConcurrentIndexedTable(dataSchema, this._queryContext, resultSize, trimSize, trimThreshold));
        ArrayList<DataTable> dataTables = new ArrayList<DataTable>(dataTablesToReduce);
        ArrayList reduceGroups = new ArrayList(numReduceThreadsToUse);
        for (i = 0; i < numReduceThreadsToUse; ++i) {
            reduceGroups.add(new ArrayList());
        }
        for (i = 0; i < numDataTables; ++i) {
            ((List)reduceGroups.get(i % numReduceThreadsToUse)).add(dataTables.get(i));
        }
        Future[] futures = new Future[numReduceThreadsToUse];
        final CountDownLatch countDownLatch = new CountDownLatch(numDataTables);
        final DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        for (int i2 = 0; i2 < numReduceThreadsToUse; ++i2) {
            final List reduceGroup = (List)reduceGroups.get(i2);
            futures[i2] = reducerContext.getExecutorService().submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    for (DataTable dataTable : reduceGroup) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        try {
                            boolean nullHandlingEnabled = GroupByDataTableReducer.this._queryContext.isNullHandlingEnabled();
                            RoaringBitmap[] nullBitmaps = null;
                            if (nullHandlingEnabled) {
                                nullBitmaps = new RoaringBitmap[GroupByDataTableReducer.this._numColumns];
                                for (int i = 0; i < GroupByDataTableReducer.this._numColumns; ++i) {
                                    nullBitmaps[i] = dataTable.getNullRowIds(i);
                                }
                            }
                            int numRows = dataTable.getNumberOfRows();
                            for (int rowId = 0; rowId < numRows; ++rowId) {
                                int colId;
                                Object[] values = new Object[GroupByDataTableReducer.this._numColumns];
                                block16: for (colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                    switch (storedColumnDataTypes[colId]) {
                                        case INT: {
                                            values[colId] = dataTable.getInt(rowId, colId);
                                            continue block16;
                                        }
                                        case LONG: {
                                            values[colId] = dataTable.getLong(rowId, colId);
                                            continue block16;
                                        }
                                        case FLOAT: {
                                            values[colId] = Float.valueOf(dataTable.getFloat(rowId, colId));
                                            continue block16;
                                        }
                                        case DOUBLE: {
                                            values[colId] = dataTable.getDouble(rowId, colId);
                                            continue block16;
                                        }
                                        case BIG_DECIMAL: {
                                            values[colId] = dataTable.getBigDecimal(rowId, colId);
                                            continue block16;
                                        }
                                        case STRING: {
                                            values[colId] = dataTable.getString(rowId, colId);
                                            continue block16;
                                        }
                                        case BYTES: {
                                            values[colId] = dataTable.getBytes(rowId, colId);
                                            continue block16;
                                        }
                                        case OBJECT: {
                                            values[colId] = dataTable.getObject(rowId, colId);
                                            continue block16;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                if (nullHandlingEnabled) {
                                    for (colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                                        values[colId] = null;
                                    }
                                }
                                indexedTable.upsert(new Record(values));
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }
            });
        }
        try {
            long timeOutMs = reducerContext.getReduceTimeOutMs() - (System.currentTimeMillis() - start);
            if (!countDownLatch.await(timeOutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out in broker reduce phase");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted in broker reduce phase", e);
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        indexedTable.finish(true);
        return indexedTable;
    }

    private int getNumReduceThreadsToUse(int numDataTables, int maxReduceThreadsPerQuery) {
        if (numDataTables < 2) {
            return 1;
        }
        return Math.min(numDataTables, maxReduceThreadsPerQuery);
    }
}

