/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOnlyStreamingReducer
implements StreamingReducer {
    private final QueryContext _queryContext;
    private DataSchema _dataSchema;
    private List<Object[]> _rows;

    public SelectionOnlyStreamingReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void init(DataTableReducerContext dataTableReducerContext) {
        this._rows = new ArrayList<Object[]>(Math.min(this._queryContext.getLimit(), 10000));
    }

    @Override
    public synchronized void reduce(ServerRoutingInstance key, DataTable dataTable) {
        this._dataSchema = this._dataSchema == null ? dataTable.getDataSchema() : this._dataSchema;
        this.reduceWithoutOrdering(dataTable, this._queryContext.getLimit(), this._queryContext.isNullHandlingEnabled());
    }

    private void reduceWithoutOrdering(DataTable dataTable, int limit, boolean nullHandlingEnabled) {
        int numColumns = dataTable.getDataSchema().size();
        int numRows = dataTable.getNumberOfRows();
        if (nullHandlingEnabled) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            for (int coldId = 0; coldId < numColumns; ++coldId) {
                nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
            }
            for (int rowId = 0; rowId < numRows && this._rows.size() < limit; ++rowId) {
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                for (int colId = 0; colId < numColumns; ++colId) {
                    if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                    row[colId] = null;
                }
                this._rows.add(row);
            }
        } else {
            for (int rowId = 0; rowId < numRows && this._rows.size() < limit; ++rowId) {
                this._rows.add(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId));
            }
        }
    }

    @Override
    public BrokerResponseNative seal() {
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(this._queryContext, this._dataSchema);
        if (this._dataSchema != null && this._rows.size() > 0) {
            brokerResponseNative.setResultTable(SelectionOperatorUtils.renderResultTableWithoutOrdering(this._rows, this._dataSchema, selectionColumns));
        } else {
            DataSchema selectionDataSchema = SelectionOperatorUtils.getResultTableDataSchema(this._dataSchema, selectionColumns);
            brokerResponseNative.setResultTable(new ResultTable(selectionDataSchema, Collections.emptyList()));
        }
        return brokerResponseNative;
    }
}

