/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.GapfillFilterHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;

class SumAvgGapfillProcessor
extends BaseGapfillProcessor {
    private final double[] _sumes;
    private final int[] _columnTypes;
    private final int[] _sumArgIndexes;
    private static final int COLUMN_TYPE_SUM = 1;
    private static final int COLUMN_TYPE_AVG = 2;
    protected Map<Integer, Integer> _filteredMap;
    protected final Map<Key, Integer> _groupByKeys = new HashMap<Key, Integer>();

    SumAvgGapfillProcessor(QueryContext queryContext, GapfillUtils.GapfillType gapfillType) {
        super(queryContext, gapfillType);
        this._columnTypes = new int[this._queryContext.getSelectExpressions().size()];
        this._sumArgIndexes = new int[this._columnTypes.length];
        this._sumes = new double[this._columnTypes.length];
    }

    protected void initializeAggregationValues(List<Object[]> rows, DataSchema dataSchema) {
        block0: for (int i = 0; i < this._columnTypes.length; ++i) {
            ExpressionContext expressionContext = this._queryContext.getSelectExpressions().get(i);
            if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) continue;
            this._columnTypes[i] = expressionContext.getFunction().getFunctionName().equalsIgnoreCase("sum") ? 1 : 2;
            ExpressionContext arg = (ExpressionContext)expressionContext.getFunction().getArguments().get(0);
            for (int j = 0; j < dataSchema.getColumnNames().length; ++j) {
                if (!arg.getLiteral().equalsIgnoreCase(dataSchema.getColumnName(j))) continue;
                this._sumArgIndexes[i] = j;
                continue block0;
            }
        }
        for (Map.Entry<Key, Integer> entry : this._groupByKeys.entrySet()) {
            if (!this._previousByGroupKey.containsKey(entry.getKey()) || this._postGapfillFilterHandler != null && !this._postGapfillFilterHandler.isMatch((Object[])this._previousByGroupKey.get(entry.getKey()))) continue;
            this._filteredMap.put(entry.getValue(), entry.getValue());
            for (int i = 0; i < this._columnTypes.length; ++i) {
                if (this._columnTypes[i] == 0) continue;
                int n = i;
                this._sumes[n] = this._sumes[n] + ((Number)rows.get(entry.getValue())[this._sumArgIndexes[i]]).doubleValue();
            }
            ++this._count;
        }
    }

    @Override
    protected List<Object[]> gapFillAndAggregate(List<Object[]> rows, DataSchema dataSchema, DataSchema resultTableSchema) {
        int[] timeBucketedRawRows = new int[this._numOfTimeBuckets + 1];
        int timeBucketedRawRowsIndex = 0;
        for (int i = 0; i < rows.size(); ++i) {
            Object[] row = rows.get(i);
            long time = this._dateTimeFormatter.fromFormatToMillis(String.valueOf(row[this._timeBucketColumnIndex]));
            int index = this.findGapfillBucketIndex(time);
            if (index >= this._numOfTimeBuckets) {
                timeBucketedRawRows[timeBucketedRawRowsIndex++] = i;
                break;
            }
            Key key = this.constructGroupKeys(row);
            this._groupByKeys.putIfAbsent(key, this._groupByKeys.size());
            if (index < 0) {
                this._previousByGroupKey.compute(key, (k, previousRow) -> {
                    if (previousRow == null) {
                        return row;
                    }
                    if ((Long)row[this._timeBucketColumnIndex] > (Long)previousRow[this._timeBucketColumnIndex]) {
                        return row;
                    }
                    return previousRow;
                });
                continue;
            }
            if (index < timeBucketedRawRowsIndex) continue;
            while (index >= timeBucketedRawRowsIndex) {
                timeBucketedRawRows[timeBucketedRawRowsIndex++] = i;
            }
        }
        while (timeBucketedRawRowsIndex < this._numOfTimeBuckets + 1) {
            timeBucketedRawRows[timeBucketedRawRowsIndex++] = rows.size();
        }
        this._filteredMap = new HashMap<Integer, Integer>();
        if (this._queryContext.getSubquery() != null && this._queryContext.getFilter() != null) {
            this._postGapfillFilterHandler = new GapfillFilterHandler(this._queryContext.getFilter(), dataSchema);
        }
        if (this._queryContext.getHavingFilter() != null) {
            this._postAggregateHavingFilterHandler = new GapfillFilterHandler(this._queryContext.getHavingFilter(), resultTableSchema);
        }
        this.initializeAggregationValues(rows, dataSchema);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        double[] aggregatedSum = new double[this._columnTypes.length];
        long aggregatedCount = 0L;
        for (long time = this._startMs; time < this._endMs; time += this._gapfillTimeBucketSize) {
            int i;
            int timeBucketIndex = this.findGapfillBucketIndex(time);
            for (i = timeBucketedRawRows[timeBucketIndex]; i < timeBucketedRawRows[timeBucketIndex + 1]; ++i) {
                int j;
                Object[] resultRow = rows.get(i);
                Key key = this.constructGroupKeys(resultRow);
                int groupKeyIndex = this._groupByKeys.get(key);
                if (this._filteredMap.containsKey(groupKeyIndex)) {
                    for (j = 0; j < this._columnTypes.length; ++j) {
                        if (this._columnTypes[j] == 0) continue;
                        int n = j;
                        this._sumes[n] = this._sumes[n] - ((Number)rows.get(this._filteredMap.get(groupKeyIndex))[this._sumArgIndexes[j]]).doubleValue();
                    }
                    this._filteredMap.remove(groupKeyIndex);
                    --this._count;
                }
                if (this._postGapfillFilterHandler != null && !this._postGapfillFilterHandler.isMatch(resultRow)) continue;
                ++this._count;
                for (j = 0; j < this._columnTypes.length; ++j) {
                    if (this._columnTypes[j] == 0) continue;
                    int n = j;
                    this._sumes[n] = this._sumes[n] + ((Number)resultRow[this._sumArgIndexes[j]]).doubleValue();
                }
                this._filteredMap.put(groupKeyIndex, i);
            }
            if (this._count > 0L) {
                aggregatedCount += this._count;
                for (i = 0; i < this._columnTypes.length; ++i) {
                    if (this._columnTypes[i] == 0) continue;
                    int n = i;
                    aggregatedSum[n] = aggregatedSum[n] + this._sumes[i];
                }
            }
            if ((timeBucketIndex + 1) % this._aggregationSize != 0 || aggregatedCount <= 0L) continue;
            Object[] aggregatedRow = new Object[this._queryContext.getSelectExpressions().size()];
            for (int i2 = 0; i2 < this._columnTypes.length; ++i2) {
                if (this._columnTypes[i2] == 0) {
                    if (dataSchema.getColumnDataType(this._timeBucketColumnIndex) == DataSchema.ColumnDataType.LONG) {
                        aggregatedRow[i2] = time - (long)(this._aggregationSize - 1) * this._gapfillTimeBucketSize;
                        continue;
                    }
                    aggregatedRow[i2] = this._dateTimeFormatter.fromMillisToFormat(time - (long)(this._aggregationSize - 1) * this._gapfillTimeBucketSize);
                    continue;
                }
                aggregatedRow[i2] = this._columnTypes[i2] == 1 ? Double.valueOf(aggregatedSum[i2]) : Double.valueOf(aggregatedSum[i2] / (double)aggregatedCount);
            }
            aggregatedSum = new double[this._columnTypes.length];
            aggregatedCount = 0L;
            if (this._postAggregateHavingFilterHandler == null || this._postAggregateHavingFilterHandler.isMatch(aggregatedRow)) {
                result.add(aggregatedRow);
            }
            if (result.size() < this._limitForAggregatedResult) continue;
            return result;
        }
        return result;
    }
}

