/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.filter;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.segment.processing.filter.FunctionEvaluatorRecordFilter;
import org.apache.pinot.core.segment.processing.filter.NoOpRecordFilter;
import org.apache.pinot.core.segment.processing.filter.RecordFilter;
import org.apache.pinot.core.segment.processing.filter.RecordFilterConfig;

public final class RecordFilterFactory {
    private RecordFilterFactory() {
    }

    public static RecordFilter getRecordFilter(RecordFilterConfig config) {
        RecordFilter recordFilter = null;
        switch (config.getRecordFilterType()) {
            case NO_OP: {
                recordFilter = new NoOpRecordFilter();
                break;
            }
            case FILTER_FUNCTION: {
                Preconditions.checkState((config.getFilterFunction() != null ? 1 : 0) != 0, (Object)"Must provide filterFunction for FILTER_FUNCTION record filter");
                recordFilter = new FunctionEvaluatorRecordFilter(config.getFilterFunction());
                break;
            }
        }
        return recordFilter;
    }

    public static enum RecordFilterType {
        NO_OP,
        FILTER_FUNCTION;

    }
}

