/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.core.segment.processing.framework.SegmentConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandlerConfig;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class SegmentProcessorConfig {
    private static final MergeType DEFAULT_MERGE_TYPE = MergeType.CONCAT;
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final TimeHandlerConfig _timeHandlerConfig;
    private final List<PartitionerConfig> _partitionerConfigs;
    private final MergeType _mergeType;
    private final Map<String, AggregationFunctionType> _aggregationTypes;
    private final SegmentConfig _segmentConfig;

    private SegmentProcessorConfig(TableConfig tableConfig, Schema schema, TimeHandlerConfig timeHandlerConfig, List<PartitionerConfig> partitionerConfigs, MergeType mergeType, Map<String, AggregationFunctionType> aggregationTypes, SegmentConfig segmentConfig) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._timeHandlerConfig = timeHandlerConfig;
        this._partitionerConfigs = partitionerConfigs;
        this._mergeType = mergeType;
        this._aggregationTypes = aggregationTypes;
        this._segmentConfig = segmentConfig;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TimeHandlerConfig getTimeHandlerConfig() {
        return this._timeHandlerConfig;
    }

    public List<PartitionerConfig> getPartitionerConfigs() {
        return this._partitionerConfigs;
    }

    public MergeType getMergeType() {
        return this._mergeType;
    }

    public Map<String, AggregationFunctionType> getAggregationTypes() {
        return this._aggregationTypes;
    }

    public SegmentConfig getSegmentConfig() {
        return this._segmentConfig;
    }

    public String toString() {
        return "SegmentProcessorConfig{_tableConfig=" + this._tableConfig + ", _schema=" + this._schema + ", _timeHandlerConfig=" + this._timeHandlerConfig + ", _partitionerConfigs=" + this._partitionerConfigs + ", _mergeType=" + this._mergeType + ", _aggregationTypes=" + this._aggregationTypes + ", _segmentConfig=" + this._segmentConfig + "}";
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private TimeHandlerConfig _timeHandlerConfig;
        private List<PartitionerConfig> _partitionerConfigs;
        private MergeType _mergeType;
        private Map<String, AggregationFunctionType> _aggregationTypes;
        private SegmentConfig _segmentConfig;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setTimeHandlerConfig(TimeHandlerConfig timeHandlerConfig) {
            this._timeHandlerConfig = timeHandlerConfig;
            return this;
        }

        public Builder setPartitionerConfigs(List<PartitionerConfig> partitionerConfigs) {
            this._partitionerConfigs = partitionerConfigs;
            return this;
        }

        public Builder setMergeType(MergeType mergeType) {
            this._mergeType = mergeType;
            return this;
        }

        public Builder setAggregationTypes(Map<String, AggregationFunctionType> aggregationTypes) {
            this._aggregationTypes = aggregationTypes;
            return this;
        }

        public Builder setSegmentConfig(SegmentConfig segmentConfig) {
            this._segmentConfig = segmentConfig;
            return this;
        }

        public SegmentProcessorConfig build() {
            Preconditions.checkState((this._tableConfig != null ? 1 : 0) != 0, (Object)"Must provide table config in SegmentProcessorConfig");
            Preconditions.checkState((this._schema != null ? 1 : 0) != 0, (Object)"Must provide schema in SegmentProcessorConfig");
            if (this._timeHandlerConfig == null) {
                this._timeHandlerConfig = new TimeHandlerConfig.Builder(TimeHandler.Type.NO_OP).build();
            }
            if (this._partitionerConfigs == null) {
                this._partitionerConfigs = Collections.emptyList();
            }
            if (this._mergeType == null) {
                this._mergeType = DEFAULT_MERGE_TYPE;
            }
            if (this._aggregationTypes == null) {
                this._aggregationTypes = Collections.emptyMap();
            }
            if (this._segmentConfig == null) {
                this._segmentConfig = new SegmentConfig.Builder().build();
            }
            return new SegmentProcessorConfig(this._tableConfig, this._schema, this._timeHandlerConfig, this._partitionerConfigs, this._mergeType, this._aggregationTypes, this._segmentConfig);
        }
    }
}

