/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.config.NettyConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.ChannelHandlerFactory;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.OsCheck;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerChannels {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerChannels.class);
    public static final String CHANNEL_LOCK_TIMEOUT_MSG = "Timeout while acquiring channel lock";
    private static final long TRY_CONNECT_CHANNEL_LOCK_TIMEOUT_MS = 5000L;
    private final QueryRouter _queryRouter;
    private final BrokerMetrics _brokerMetrics;
    private final ThreadLocal<TSerializer> _threadLocalTSerializer;
    private final ConcurrentHashMap<ServerRoutingInstance, ServerChannel> _serverToChannelMap = new ConcurrentHashMap();
    private final TlsConfig _tlsConfig;
    private final EventLoopGroup _eventLoopGroup;
    private final Class<? extends SocketChannel> _channelClass;

    public ServerChannels(QueryRouter queryRouter, BrokerMetrics brokerMetrics, @Nullable NettyConfig nettyConfig, @Nullable TlsConfig tlsConfig) {
        boolean enableNativeTransports = nettyConfig != null && nettyConfig.isNativeTransportsEnabled();
        OsCheck.OSType operatingSystemType = OsCheck.getOperatingSystemType();
        if (enableNativeTransports && operatingSystemType == OsCheck.OSType.Linux && Epoll.isAvailable()) {
            this._eventLoopGroup = new EpollEventLoopGroup();
            this._channelClass = EpollSocketChannel.class;
            LOGGER.info("Using Epoll event loop");
        } else if (enableNativeTransports && operatingSystemType == OsCheck.OSType.MacOS && KQueue.isAvailable()) {
            this._eventLoopGroup = new KQueueEventLoopGroup();
            this._channelClass = KQueueSocketChannel.class;
            LOGGER.info("Using KQueue event loop");
        } else {
            this._eventLoopGroup = new NioEventLoopGroup();
            this._channelClass = NioSocketChannel.class;
            StringBuilder log = new StringBuilder("Using NIO event loop");
            if (operatingSystemType == OsCheck.OSType.Linux && enableNativeTransports) {
                log.append(", as Epoll is not available: ").append(Epoll.unavailabilityCause());
            } else if (operatingSystemType == OsCheck.OSType.MacOS && enableNativeTransports) {
                log.append(", as KQueue is not available: ").append(KQueue.unavailabilityCause());
            }
            LOGGER.info(log.toString());
        }
        this._queryRouter = queryRouter;
        this._brokerMetrics = brokerMetrics;
        this._tlsConfig = tlsConfig;
        this._threadLocalTSerializer = ThreadLocal.withInitial(() -> {
            try {
                return new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            }
            catch (TTransportException e) {
                throw new RuntimeException("Failed to initialize Thrift Serializer", e);
            }
        });
    }

    public void sendRequest(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, InstanceRequest instanceRequest, long timeoutMs) throws Exception {
        byte[] requestBytes = this._threadLocalTSerializer.get().serialize((TBase)instanceRequest);
        this._serverToChannelMap.computeIfAbsent(serverRoutingInstance, x$0 -> new ServerChannel((ServerRoutingInstance)x$0)).sendRequest(rawTableName, asyncQueryResponse, serverRoutingInstance, requestBytes, timeoutMs);
    }

    public void connect(ServerRoutingInstance serverRoutingInstance) throws InterruptedException, TimeoutException {
        this._serverToChannelMap.computeIfAbsent(serverRoutingInstance, x$0 -> new ServerChannel((ServerRoutingInstance)x$0)).connect();
    }

    public void shutDown() {
        this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    @ThreadSafe
    private class ServerChannel {
        final ServerRoutingInstance _serverRoutingInstance;
        final Bootstrap _bootstrap;
        final ReentrantLock _channelLock = new ReentrantLock();
        Channel _channel;

        ServerChannel(ServerRoutingInstance serverRoutingInstance) {
            this._serverRoutingInstance = serverRoutingInstance;
            this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(serverRoutingInstance.getHostname(), serverRoutingInstance.getPort()).group(ServerChannels.this._eventLoopGroup)).channel(ServerChannels.this._channelClass)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    if (ServerChannels.this._tlsConfig != null) {
                        ch.pipeline().addLast("ssl", ChannelHandlerFactory.getClientTlsHandler(ServerChannels.this._tlsConfig, ch));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldBasedFrameDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldPrepender()});
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getDataTableHandler(ServerChannels.this._queryRouter, ServerChannel.this._serverRoutingInstance, ServerChannels.this._brokerMetrics)});
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendRequest(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, byte[] requestBytes, long timeoutMs) throws InterruptedException, TimeoutException {
            if (this._channelLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS)) {
                try {
                    this.connectWithoutLocking();
                    this.sendRequestWithoutLocking(rawTableName, asyncQueryResponse, serverRoutingInstance, requestBytes);
                }
                finally {
                    this._channelLock.unlock();
                }
            } else {
                throw new TimeoutException(ServerChannels.CHANNEL_LOCK_TIMEOUT_MSG);
            }
        }

        void connectWithoutLocking() throws InterruptedException {
            if (this._channel == null || !this._channel.isActive()) {
                long startTime = System.currentTimeMillis();
                this._channel = this._bootstrap.connect().sync().channel();
                ServerChannels.this._brokerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)BrokerGauge.NETTY_CONNECTION_CONNECT_TIME_MS, System.currentTimeMillis() - startTime);
            }
        }

        void sendRequestWithoutLocking(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, byte[] requestBytes) {
            long startTimeMs = System.currentTimeMillis();
            this._channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])requestBytes)).addListener(f -> {
                long requestSentLatencyMs = System.currentTimeMillis() - startTimeMs;
                ServerChannels.this._brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.NETTY_CONNECTION_SEND_REQUEST_LATENCY, requestSentLatencyMs, TimeUnit.MILLISECONDS);
                asyncQueryResponse.markRequestSent(serverRoutingInstance, requestSentLatencyMs);
            });
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_REQUESTS_SENT, 1L);
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_BYTES_SENT, (long)requestBytes.length);
        }

        void connect() throws InterruptedException, TimeoutException {
            if (this._channelLock.tryLock(5000L, TimeUnit.MILLISECONDS)) {
                try {
                    this.connectWithoutLocking();
                }
                finally {
                    this._channelLock.unlock();
                }
            } else {
                throw new TimeoutException(ServerChannels.CHANNEL_LOCK_TIMEOUT_MSG);
            }
        }
    }
}

