/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.access;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.config.provider.AccessControlUserCache;
import org.apache.pinot.common.utils.BcryptUtils;
import org.apache.pinot.core.auth.BasicAuthPrincipal;
import org.apache.pinot.core.auth.BasicAuthUtils;
import org.apache.pinot.core.auth.ZkBasicAuthPrincipal;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AccessControlFactory;
import org.apache.pinot.server.access.GrpcRequesterIdentity;
import org.apache.pinot.server.access.HttpRequesterIdentity;
import org.apache.pinot.server.access.RequesterIdentity;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class ZkBasicAuthAccessFactory
implements AccessControlFactory {
    private static final String AUTHORIZATION_KEY = "authorization";
    private HelixManager _helixManager;
    private AccessControl _accessControl;

    @Override
    public void init(PinotConfiguration configuration, HelixManager helixManager) {
        this._helixManager = helixManager;
    }

    @Override
    public AccessControl create() {
        if (this._accessControl == null) {
            this._accessControl = new BasicAuthAccessControl(this._helixManager);
        }
        return this._accessControl;
    }

    private static class BasicAuthAccessControl
    implements AccessControl {
        private Map<String, ZkBasicAuthPrincipal> _name2principal;
        private AccessControlUserCache _userCache;
        private HelixManager _innerHelixManager;

        public BasicAuthAccessControl(HelixManager helixManager) {
            this._innerHelixManager = helixManager;
        }

        public void initUserCache() {
            if (this._userCache == null) {
                this._userCache = new AccessControlUserCache(this._innerHelixManager.getHelixPropertyStore());
            }
        }

        @Override
        public boolean isAuthorizedChannel(ChannelHandlerContext channelHandlerContext) {
            return true;
        }

        @Override
        public boolean hasDataAccess(RequesterIdentity requesterIdentity, String tableName) {
            if (this._userCache == null) {
                this.initUserCache();
            }
            Collection<String> tokens = this.getTokens(requesterIdentity);
            this._name2principal = BasicAuthUtils.extractBasicAuthPrincipals(this._userCache.getAllServerUserConfig()).stream().collect(Collectors.toMap(BasicAuthPrincipal::getName, p -> p));
            Map<String, String> name2password = tokens.stream().collect(Collectors.toMap(BasicAuthUtils::extractUsername, BasicAuthUtils::extractPassword));
            Map<String, ZkBasicAuthPrincipal> password2principal = name2password.keySet().stream().collect(Collectors.toMap(name2password::get, this._name2principal::get));
            return password2principal.entrySet().stream().filter(entry -> BcryptUtils.checkpw((String)((String)entry.getKey()), (String)((ZkBasicAuthPrincipal)entry.getValue()).getPassword())).map(u -> (ZkBasicAuthPrincipal)u.getValue()).filter(Objects::nonNull).findFirst().map(zkprincipal -> StringUtils.isEmpty((String)tableName) || zkprincipal.hasTable(TableNameBuilder.extractRawTableName((String)tableName))).orElse(false);
        }

        private Collection<String> getTokens(RequesterIdentity requesterIdentity) {
            if (requesterIdentity instanceof GrpcRequesterIdentity) {
                GrpcRequesterIdentity identity = (GrpcRequesterIdentity)requesterIdentity;
                return identity.getGrpcMetadata().get((Object)ZkBasicAuthAccessFactory.AUTHORIZATION_KEY);
            }
            if (requesterIdentity instanceof HttpRequesterIdentity) {
                HttpRequesterIdentity identity = (HttpRequesterIdentity)requesterIdentity;
                return identity.getHttpHeaders().get((Object)ZkBasicAuthAccessFactory.AUTHORIZATION_KEY);
            }
            throw new UnsupportedOperationException("GrpcRequesterIdentity or HttpRequesterIdentity is required");
        }
    }
}

