/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.table;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.ResultContinuation;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.BaseRequest;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.PathUtility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableRequestOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.table.TableUpdateType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;

final class TableRequest {
    private static void applyContinuationToQueryBuilder(UriQueryBuilder builder, ResultContinuation continuationToken) throws StorageException {
        if (continuationToken != null) {
            if (continuationToken.getNextPartitionKey() != null) {
                builder.add("NextPartitionKey", continuationToken.getNextPartitionKey());
            }
            if (continuationToken.getNextRowKey() != null) {
                builder.add("NextRowKey", continuationToken.getNextRowKey());
            }
            if (continuationToken.getNextTableName() != null) {
                builder.add("NextTableName", continuationToken.getNextTableName());
            }
        }
    }

    public static HttpURLConnection batch(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String batchID) throws IOException, URISyntaxException, StorageException {
        URI queryUri = PathUtility.appendPathToSingleUri(rootUri, "$batch");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, tableOptions, queryBuilder, opContext);
        TableRequest.setAcceptHeaderForHttpWebRequest(retConnection, tableOptions.getTablePayloadFormat());
        retConnection.setRequestProperty("Content-Type", String.format("multipart/mixed; boundary=%s", batchID));
        retConnection.setRequestProperty("MaxDataServiceVersion", "3.0");
        retConnection.setRequestMethod("POST");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    private static HttpURLConnection coreCreate(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String eTag, String identity, String requestMethod) throws IOException, URISyntaxException, StorageException {
        URI queryUri = null;
        queryUri = !Utility.isNullOrEmpty(identity) ? PathUtility.appendPathToSingleUri(rootUri, tableName.concat(String.format("(%s)", identity))) : PathUtility.appendPathToSingleUri(rootUri, tableName);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, tableOptions, queryBuilder, opContext);
        TableRequest.setAcceptHeaderForHttpWebRequest(retConnection, tableOptions.getTablePayloadFormat());
        retConnection.setRequestProperty("Content-Type", "application/json");
        retConnection.setRequestProperty("MaxDataServiceVersion", "3.0");
        if (!Utility.isNullOrEmpty(eTag)) {
            retConnection.setRequestProperty("If-Match", eTag);
        }
        retConnection.setRequestMethod(requestMethod);
        return retConnection;
    }

    public static HttpURLConnection delete(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String identity, String eTag) throws IOException, URISyntaxException, StorageException {
        return TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, eTag, identity, "DELETE");
    }

    public static HttpURLConnection insert(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String identity, String eTag, boolean echoContent, TableUpdateType updateType) throws IOException, URISyntaxException, StorageException {
        URLConnection retConnection = null;
        if (updateType == null) {
            retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, eTag, null, "POST");
            retConnection.setRequestProperty("Prefer", echoContent ? "return-content" : "return-no-content");
        } else if (updateType == TableUpdateType.MERGE) {
            tableOptions.assertNoEncryptionPolicyOrStrictMode();
            retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, null, identity, "POST");
            retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        } else if (updateType == TableUpdateType.REPLACE) {
            retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, null, identity, "PUT");
        }
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection merge(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String identity, String eTag) throws IOException, URISyntaxException, StorageException {
        tableOptions.assertNoEncryptionPolicyOrStrictMode();
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, eTag, identity, "POST");
        retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection query(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String identity, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        if (queryBuilder == null) {
            queryBuilder = new UriQueryBuilder();
        }
        TableRequest.applyContinuationToQueryBuilder(queryBuilder, continuationToken);
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, null, identity, "GET");
        return retConnection;
    }

    public static HttpURLConnection update(URI rootUri, TableRequestOptions tableOptions, UriQueryBuilder queryBuilder, OperationContext opContext, String tableName, String identity, String eTag) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableOptions, queryBuilder, opContext, tableName, eTag, identity, "PUT");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection setAcl(URI rootUri, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, options, queryBuilder, opContext);
        retConnection.setRequestMethod("PUT");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection getAcl(URI rootUri, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, options, queryBuilder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    private static void setAcceptHeaderForHttpWebRequest(HttpURLConnection retConnection, TablePayloadFormat payloadFormat) {
        if (payloadFormat == TablePayloadFormat.JsonFullMetadata) {
            retConnection.setRequestProperty("Accept", "application/json;odata=fullmetadata");
        } else if (payloadFormat == TablePayloadFormat.Json) {
            retConnection.setRequestProperty("Accept", "application/json;odata=minimalmetadata");
        } else if (payloadFormat == TablePayloadFormat.JsonNoMetadata) {
            retConnection.setRequestProperty("Accept", "application/json;odata=nometadata");
        }
    }

    private TableRequest() {
    }
}

