/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.AbstractEncTypeHandler;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.Confounder;

public abstract class KeKiEnc
extends AbstractEncTypeHandler {
    public KeKiEnc(EncryptProvider encProvider, HashProvider hashProvider) {
        super(encProvider, hashProvider, 16);
    }

    @Override
    public int paddingSize() {
        return 0;
    }

    @Override
    protected int paddingLength(int inputLen) {
        int payloadLen = this.confounderSize() + inputLen;
        int padding = this.paddingSize();
        if (padding == 0 || payloadLen % padding == 0) {
            return 0;
        }
        return padding - payloadLen % padding;
    }

    @Override
    protected void encryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage) throws KrbException {
        int confounderLen = workLens[0];
        int checksumLen = workLens[1];
        int inputLen = workLens[2];
        int paddingLen = workLens[3];
        byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
        byte[] ke = ((DkKeyMaker)this.keyMaker()).dk(key, constant);
        constant[4] = 85;
        byte[] ki = ((DkKeyMaker)this.keyMaker()).dk(key, constant);
        byte[] tmpEnc = new byte[confounderLen + inputLen + paddingLen];
        byte[] confounder = Confounder.makeBytes(confounderLen);
        System.arraycopy(confounder, 0, tmpEnc, 0, confounderLen);
        System.arraycopy(workBuffer, confounderLen + checksumLen, tmpEnc, confounderLen, inputLen);
        for (int i = confounderLen + inputLen; i < paddingLen; ++i) {
            tmpEnc[i] = 0;
        }
        byte[] checksum = this.makeChecksum(ki, tmpEnc, checksumLen);
        this.encProvider().encrypt(ke, iv, tmpEnc);
        System.arraycopy(tmpEnc, 0, workBuffer, 0, tmpEnc.length);
        System.arraycopy(checksum, 0, workBuffer, tmpEnc.length, checksum.length);
    }

    @Override
    protected byte[] decryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage) throws KrbException {
        int confounderLen = workLens[0];
        int checksumLen = workLens[1];
        int dataLen = workLens[2];
        byte[] constant = new byte[5];
        BytesUtil.int2bytes(usage, constant, 0, true);
        constant[4] = -86;
        byte[] ke = ((DkKeyMaker)this.keyMaker()).dk(key, constant);
        constant[4] = 85;
        byte[] ki = ((DkKeyMaker)this.keyMaker()).dk(key, constant);
        byte[] tmpEnc = new byte[confounderLen + dataLen];
        System.arraycopy(workBuffer, 0, tmpEnc, 0, confounderLen + dataLen);
        byte[] checksum = new byte[checksumLen];
        System.arraycopy(workBuffer, confounderLen + dataLen, checksum, 0, checksumLen);
        this.encProvider().decrypt(ke, iv, tmpEnc);
        byte[] newChecksum = this.makeChecksum(ki, tmpEnc, checksumLen);
        if (!KeKiEnc.checksumEqual(checksum, newChecksum)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BAD_INTEGRITY);
        }
        byte[] data = new byte[dataLen];
        System.arraycopy(tmpEnc, confounderLen, data, 0, dataLen);
        return data;
    }

    protected abstract byte[] makeChecksum(byte[] var1, byte[] var2, int var3) throws KrbException;
}

