/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionRegistry.class);
    private static final Map<String, Map<Integer, FunctionInfo>> FUNCTION_INFO_MAP = new HashMap<String, Map<Integer, FunctionInfo>>();

    private FunctionRegistry() {
    }

    public static void init() {
    }

    public static void registerFunction(Method method, boolean nullableParameters) {
        FunctionRegistry.registerFunction(method.getName(), method, nullableParameters);
    }

    public static void registerFunction(String functionName, Method method, boolean nullableParameters) {
        FunctionInfo functionInfo = new FunctionInfo(method, method.getDeclaringClass(), nullableParameters);
        String canonicalName = FunctionRegistry.canonicalize(functionName);
        Map functionInfoMap = FUNCTION_INFO_MAP.computeIfAbsent(canonicalName, k -> new HashMap());
        Preconditions.checkState((functionInfoMap.put(method.getParameterCount(), functionInfo) == null ? 1 : 0) != 0, (String)"Function: %s with %s parameters is already registered", (Object)functionName, (int)method.getParameterCount());
    }

    public static boolean containsFunction(String functionName) {
        return FUNCTION_INFO_MAP.containsKey(FunctionRegistry.canonicalize(functionName));
    }

    @Nullable
    public static FunctionInfo getFunctionInfo(String functionName, int numParameters) {
        Map<Integer, FunctionInfo> functionInfoMap = FUNCTION_INFO_MAP.get(FunctionRegistry.canonicalize(functionName));
        return functionInfoMap != null ? functionInfoMap.get(numParameters) : null;
    }

    private static String canonicalize(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    static {
        long startTimeMs = System.currentTimeMillis();
        Set methods = PinotReflectionUtils.getMethodsThroughReflection((String)".*\\.function\\..*", ScalarFunction.class);
        for (Method method : methods) {
            ScalarFunction scalarFunction;
            if (!Modifier.isPublic(method.getModifiers()) || !(scalarFunction = method.getAnnotation(ScalarFunction.class)).enabled()) continue;
            String[] scalarFunctionNames = scalarFunction.names();
            boolean nullableParameters = scalarFunction.nullableParameters();
            if (scalarFunctionNames.length > 0) {
                for (String name : scalarFunctionNames) {
                    FunctionRegistry.registerFunction(name, method, nullableParameters);
                }
                continue;
            }
            FunctionRegistry.registerFunction(method, nullableParameters);
        }
        LOGGER.info("Initialized FunctionRegistry with {} functions: {} in {}ms", new Object[]{FUNCTION_INFO_MAP.size(), FUNCTION_INFO_MAP.keySet(), System.currentTimeMillis() - startTimeMs});
    }
}

