/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.airlift.stats.TimeStat;
import io.trino.plugin.elasticsearch.ElasticsearchConfig;
import io.trino.plugin.elasticsearch.client.BackpressureRestClient;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.function.CheckedSupplier;
import org.apache.http.Header;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;

public class BackpressureRestHighLevelClient
implements Closeable {
    private static final Logger log = Logger.get(BackpressureRestHighLevelClient.class);
    private final RestHighLevelClient delegate;
    private final BackpressureRestClient backpressureRestClient;
    private final RetryPolicy<ActionResponse> retryPolicy;
    private final TimeStat backpressureStats;
    private final ThreadLocal<Stopwatch> stopwatch = ThreadLocal.withInitial(Stopwatch::createUnstarted);

    public BackpressureRestHighLevelClient(RestClientBuilder restClientBuilder, ElasticsearchConfig config, TimeStat backpressureStats) {
        this.backpressureStats = Objects.requireNonNull(backpressureStats, "backpressureStats is null");
        this.delegate = new RestHighLevelClient(Objects.requireNonNull(restClientBuilder, "restClientBuilder is null"));
        this.backpressureRestClient = new BackpressureRestClient(this.delegate.getLowLevelClient(), config, backpressureStats);
        this.retryPolicy = (RetryPolicy)((RetryPolicy)((RetryPolicy)new RetryPolicy().withMaxAttempts(-1).withMaxDuration(Duration.ofMillis(config.getMaxRetryTime().toMillis())).withBackoff(config.getBackoffInitDelay().toMillis(), config.getBackoffMaxDelay().toMillis(), ChronoUnit.MILLIS).withJitter(0.125).handleIf(BackpressureRestHighLevelClient::isBackpressure)).onFailedAttempt(this::onFailedAttempt).onSuccess(this::onComplete)).onFailure(this::onComplete);
    }

    public BackpressureRestClient getLowLevelClient() {
        return this.backpressureRestClient;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public SearchResponse search(SearchRequest searchRequest, Header ... headers) throws IOException {
        return (SearchResponse)this.executeWithRetries(() -> this.delegate.search(searchRequest, headers));
    }

    public SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, Header ... headers) throws IOException {
        return (SearchResponse)this.executeWithRetries(() -> this.delegate.searchScroll(searchScrollRequest, headers));
    }

    public ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, Header ... headers) throws IOException {
        return (ClearScrollResponse)this.executeWithRetries(() -> this.delegate.clearScroll(clearScrollRequest, headers));
    }

    private static boolean isBackpressure(Throwable throwable) {
        return throwable instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)throwable).status() == RestStatus.TOO_MANY_REQUESTS;
    }

    private void onComplete(ExecutionCompletedEvent<ActionResponse> executionCompletedEvent) {
        if (this.stopwatch.get().isRunning()) {
            long delayMillis = this.stopwatch.get().elapsed(TimeUnit.MILLISECONDS);
            log.debug("Adding %s milliseconds to backpressure stats", new Object[]{delayMillis});
            this.stopwatch.get().reset();
            this.backpressureStats.add((double)delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private <T extends ActionResponse> T executeWithRetries(CheckedSupplier<T> supplier) throws IOException {
        try {
            return (T)((ActionResponse)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).get(supplier));
        }
        catch (FailsafeException e) {
            Throwable throwable = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)throwable, IOException.class);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException("Unexpected cause from FailsafeException", throwable);
        }
    }

    private void onFailedAttempt(ExecutionAttemptedEvent<ActionResponse> executionAttemptedEvent) {
        log.debug("REST attempt failed: %s", new Object[]{executionAttemptedEvent.getLastFailure()});
        if (!this.stopwatch.get().isRunning()) {
            this.stopwatch.get().start();
        }
    }
}

