/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import io.trino.spi.exchange.ExchangeId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.crypto.SecretKey;

@Immutable
public class ExchangeSourceFile {
    private final URI fileUri;
    private final Optional<SecretKey> secretKey;
    private final long fileSize;
    private final ExchangeId exchangeId;
    private final int sourceTaskPartitionId;
    private final int sourceTaskAttemptId;

    public ExchangeSourceFile(URI fileUri, Optional<SecretKey> secretKey, long fileSize, ExchangeId exchangeId, int sourceTaskPartitionId, int sourceTaskAttemptId) {
        this.fileUri = Objects.requireNonNull(fileUri, "fileUri is null");
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
        this.fileSize = fileSize;
        this.exchangeId = Objects.requireNonNull(exchangeId, "exchangeId is null");
        this.sourceTaskPartitionId = sourceTaskPartitionId;
        this.sourceTaskAttemptId = sourceTaskAttemptId;
    }

    public URI getFileUri() {
        return this.fileUri;
    }

    public Optional<SecretKey> getSecretKey() {
        return this.secretKey;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    public int getSourceTaskPartitionId() {
        return this.sourceTaskPartitionId;
    }

    public int getSourceTaskAttemptId() {
        return this.sourceTaskAttemptId;
    }
}

