/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.exchange.ExchangeSinkHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class FileSystemExchangeSinkHandle
implements ExchangeSinkHandle {
    private final int partitionId;
    private final Optional<byte[]> secretKey;

    @JsonCreator
    public FileSystemExchangeSinkHandle(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="secretKey") Optional<byte[]> secretKey) {
        this.partitionId = partitionId;
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public Optional<byte[]> getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemExchangeSinkHandle that = (FileSystemExchangeSinkHandle)o;
        if (this.secretKey.isPresent() && that.secretKey.isPresent()) {
            return this.partitionId == that.getPartitionId() && Arrays.equals(this.secretKey.get(), that.secretKey.get());
        }
        return this.partitionId == that.getPartitionId() && this.secretKey.isEmpty() && that.secretKey.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.secretKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("secretKey", this.secretKey.map(value -> "[REDACTED]")).toString();
    }
}

