/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class FileSystemExchangeSourceHandle
implements ExchangeSourceHandle {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(FileSystemExchangeSourceHandle.class).instanceSize());
    private final ExchangeId exchangeId;
    private final int partitionId;
    private final List<SourceFile> files;
    private final Optional<byte[]> secretKey;

    @JsonCreator
    public FileSystemExchangeSourceHandle(@JsonProperty(value="exchangeId") ExchangeId exchangeId, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="files") List<SourceFile> files, @JsonProperty(value="secretKey") Optional<byte[]> secretKey) {
        this.exchangeId = Objects.requireNonNull(exchangeId, "exchangeId is null");
        this.partitionId = partitionId;
        this.files = ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null"));
        this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
    }

    @JsonProperty
    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    public long getDataSizeInBytes() {
        return this.files.stream().mapToLong(SourceFile::getFileSize).sum();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.files, SourceFile::getRetainedSizeInBytes) + SizeOf.sizeOf(this.secretKey, SizeOf::sizeOf);
    }

    @JsonProperty
    public List<SourceFile> getFiles() {
        return this.files;
    }

    @JsonProperty
    public Optional<byte[]> getSecretKey() {
        return this.secretKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exchangeId", (Object)this.exchangeId).add("partitionId", this.partitionId).add("files", this.files).add("secretKey", this.secretKey.map(value -> "[REDACTED]")).toString();
    }

    public static class SourceFile {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(SourceFile.class).instanceSize());
        private final String filePath;
        private final long fileSize;
        private final int sourceTaskPartitionId;
        private final int sourceTaskAttemptId;

        @JsonCreator
        public SourceFile(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="sourceTaskPartitionId") int sourceTaskPartitionId, @JsonProperty(value="sourceTaskAttemptId") int sourceTaskAttemptId) {
            this.filePath = Objects.requireNonNull(filePath, "filePath is null");
            this.fileSize = fileSize;
            this.sourceTaskPartitionId = sourceTaskPartitionId;
            this.sourceTaskAttemptId = sourceTaskAttemptId;
        }

        @JsonProperty
        public String getFilePath() {
            return this.filePath;
        }

        @JsonProperty
        public long getFileSize() {
            return this.fileSize;
        }

        @JsonProperty
        public int getSourceTaskPartitionId() {
            return this.sourceTaskPartitionId;
        }

        @JsonProperty
        public int getSourceTaskAttemptId() {
            return this.sourceTaskAttemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceFile that = (SourceFile)o;
            return this.fileSize == that.fileSize && this.sourceTaskPartitionId == that.sourceTaskPartitionId && this.sourceTaskAttemptId == that.sourceTaskAttemptId && Objects.equals(this.filePath, that.filePath);
        }

        public int hashCode() {
            return Objects.hash(this.filePath, this.fileSize, this.sourceTaskPartitionId, this.sourceTaskAttemptId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filePath", (Object)this.filePath).add("fileSize", this.fileSize).add("sourceTaskPartitionId", this.sourceTaskPartitionId).add("sourceTaskAttemptId", this.sourceTaskAttemptId).toString();
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.filePath);
        }
    }
}

