/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.azure;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ExchangeAzureConfig {
    private Optional<String> azureStorageConnectionString = Optional.empty();
    private DataSize azureStorageBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxErrorRetries = 10;

    public Optional<String> getAzureStorageConnectionString() {
        return this.azureStorageConnectionString;
    }

    @Config(value="exchange.azure.connection-string")
    @ConfigSecuritySensitive
    public ExchangeAzureConfig setAzureStorageConnectionString(String azureStorageConnectionString) {
        this.azureStorageConnectionString = Optional.ofNullable(azureStorageConnectionString);
        return this;
    }

    @NotNull
    @MinDataSize(value="4MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="4MB") @MaxDataSize(value="256MB") DataSize getAzureStorageBlockSize() {
        return this.azureStorageBlockSize;
    }

    @Config(value="exchange.azure.block-size")
    @ConfigDescription(value="Block size for Azure High-Throughput Block Blob")
    public ExchangeAzureConfig setAzureStorageBlockSize(DataSize azureStorageBlockSize) {
        this.azureStorageBlockSize = azureStorageBlockSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxErrorRetries() {
        return this.maxErrorRetries;
    }

    @Config(value="exchange.azure.max-error-retries")
    public ExchangeAzureConfig setMaxErrorRetries(int maxErrorRetries) {
        this.maxErrorRetries = maxErrorRetries;
        return this;
    }
}

