/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.local;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.plugin.exchange.filesystem.ExchangeSourceFile;
import io.trino.plugin.exchange.filesystem.ExchangeStorageReader;
import io.trino.plugin.exchange.filesystem.ExchangeStorageWriter;
import io.trino.plugin.exchange.filesystem.FileStatus;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.openjdk.jol.info.ClassLayout;

public class LocalFileSystemExchangeStorage
implements FileSystemExchangeStorage {
    private static final int BUFFER_SIZE_IN_BYTES = Math.toIntExact(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE).toBytes());

    @Override
    public void createDirectories(URI dir) throws IOException {
        Files.createDirectories(Paths.get(dir.getPath(), new String[0]), new FileAttribute[0]);
    }

    @Override
    public ExchangeStorageReader createExchangeStorageReader(List<ExchangeSourceFile> sourceFiles, int maxPageStorageSize) {
        return new LocalExchangeStorageReader(sourceFiles);
    }

    @Override
    public ExchangeStorageWriter createExchangeStorageWriter(URI file, Optional<SecretKey> secretKey) {
        return new LocalExchangeStorageWriter(file, secretKey);
    }

    @Override
    public ListenableFuture<Void> createEmptyFile(URI file) {
        try {
            Files.createFile(Paths.get(file.getPath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException | RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public ListenableFuture<Void> deleteRecursively(List<URI> directories) {
        for (URI dir : directories) {
            try {
                MoreFiles.deleteRecursively((Path)Paths.get(dir.getPath(), new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public ListenableFuture<List<FileStatus>> listFilesRecursively(URI dir) {
        ImmutableList.Builder builder = ImmutableList.builder();
        try (Stream<Path> paths = Files.walk(Paths.get(dir.getPath(), new String[0]), new FileVisitOption[0]);){
            for (Path file : (ImmutableList)paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(ImmutableList.toImmutableList())) {
                builder.add((Object)new FileStatus(file.toUri().toString(), Files.size(file)));
            }
        }
        catch (IOException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture((Object)builder.build());
    }

    @Override
    public int getWriteBufferSize() {
        return BUFFER_SIZE_IN_BYTES;
    }

    @Override
    public void close() {
    }

    @ThreadSafe
    private static class LocalExchangeStorageReader
    implements ExchangeStorageReader {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(LocalExchangeStorageReader.class).instanceSize());
        @GuardedBy(value="this")
        private final Queue<ExchangeSourceFile> sourceFiles;
        @GuardedBy(value="this")
        private InputStreamSliceInput sliceInput;
        @GuardedBy(value="this")
        private boolean closed;

        public LocalExchangeStorageReader(List<ExchangeSourceFile> sourceFiles) {
            this.sourceFiles = new ArrayDeque<ExchangeSourceFile>((Collection)Objects.requireNonNull(sourceFiles, "sourceFiles is null"));
        }

        @Override
        public synchronized Slice read() throws IOException {
            if (this.closed) {
                return null;
            }
            if (this.sliceInput != null && this.sliceInput.isReadable()) {
                return this.sliceInput.readSlice(this.sliceInput.readInt());
            }
            ExchangeSourceFile sourceFile = this.sourceFiles.poll();
            if (sourceFile == null) {
                this.close();
                return null;
            }
            this.sliceInput = this.getSliceInput(sourceFile);
            return this.sliceInput.readSlice(this.sliceInput.readInt());
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            return Futures.immediateVoidFuture();
        }

        @Override
        public synchronized long getRetainedSize() {
            return (long)INSTANCE_SIZE + (this.sliceInput == null ? 0L : this.sliceInput.getRetainedSize());
        }

        @Override
        public synchronized boolean isFinished() {
            return this.closed;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.sliceInput != null) {
                this.sliceInput.close();
                this.sliceInput = null;
            }
        }

        private InputStreamSliceInput getSliceInput(ExchangeSourceFile sourceFile) throws FileNotFoundException {
            File file = Paths.get(sourceFile.getFileUri()).toFile();
            Optional<SecretKey> secretKey = sourceFile.getSecretKey();
            if (secretKey.isPresent()) {
                try {
                    Cipher cipher = Cipher.getInstance("AES");
                    cipher.init(2, secretKey.get());
                    return new InputStreamSliceInput((InputStream)new CipherInputStream(new FileInputStream(file), cipher), BUFFER_SIZE_IN_BYTES);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create CipherInputStream: " + e.getMessage(), (Throwable)e);
                }
            }
            return new InputStreamSliceInput((InputStream)new FileInputStream(file), BUFFER_SIZE_IN_BYTES);
        }
    }

    @NotThreadSafe
    private static class LocalExchangeStorageWriter
    implements ExchangeStorageWriter {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(LocalExchangeStorageWriter.class).instanceSize());
        private final OutputStream outputStream;

        public LocalExchangeStorageWriter(URI file, Optional<SecretKey> secretKey) {
            block5: {
                try {
                    if (secretKey.isPresent()) {
                        try {
                            Cipher cipher = Cipher.getInstance("AES");
                            cipher.init(1, secretKey.get());
                            this.outputStream = new CipherOutputStream(new FileOutputStream(Paths.get(file.getPath(), new String[0]).toFile()), cipher);
                            break block5;
                        }
                        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create CipherOutputStream: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    this.outputStream = new FileOutputStream(Paths.get(file.getPath(), new String[0]).toFile());
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        @Override
        public ListenableFuture<Void> write(Slice slice) {
            try {
                this.outputStream.write(slice.getBytes());
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> finish() {
            try {
                this.outputStream.close();
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> abort() {
            try {
                this.outputStream.close();
            }
            catch (IOException | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public long getRetainedSize() {
            return INSTANCE_SIZE;
        }
    }
}

