/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.valuesets.TrinoThriftValueSet;
import io.trino.spi.predicate.Domain;
import java.util.Objects;

@ThriftStruct
public final class TrinoThriftDomain {
    private final TrinoThriftValueSet valueSet;
    private final boolean nullAllowed;

    @ThriftConstructor
    public TrinoThriftDomain(TrinoThriftValueSet valueSet, boolean nullAllowed) {
        this.valueSet = Objects.requireNonNull(valueSet, "valueSet is null");
        this.nullAllowed = nullAllowed;
    }

    @ThriftField(value=1)
    public TrinoThriftValueSet getValueSet() {
        return this.valueSet;
    }

    @ThriftField(value=2)
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftDomain other = (TrinoThriftDomain)obj;
        return Objects.equals(this.valueSet, other.valueSet) && this.nullAllowed == other.nullAllowed;
    }

    public int hashCode() {
        return Objects.hash(this.valueSet, this.nullAllowed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueSet", (Object)this.valueSet).add("nullAllowed", this.nullAllowed).toString();
    }

    public static TrinoThriftDomain fromDomain(Domain domain) {
        return new TrinoThriftDomain(TrinoThriftValueSet.fromValueSet(domain.getValues()), domain.isNullAllowed());
    }
}

