/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;

public class ClassLoaderSafeUpdatablePageSource
implements UpdatablePageSource {
    private final UpdatablePageSource delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeUpdatablePageSource(UpdatablePageSource delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public long getCompletedBytes() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getCompletedBytes();
            return l;
        }
    }

    public OptionalLong getCompletedPositions() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.getCompletedPositions();
            return optionalLong;
        }
    }

    public long getReadTimeNanos() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getReadTimeNanos();
            return l;
        }
    }

    public boolean isFinished() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.isFinished();
            return bl;
        }
    }

    public Page getNextPage() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Page page = this.delegate.getNextPage();
            return page;
        }
    }

    public long getMemoryUsage() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getMemoryUsage();
            return l;
        }
    }

    public void close() throws IOException {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.close();
        }
    }

    public CompletableFuture<?> isBlocked() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.isBlocked();
            return completableFuture;
        }
    }

    public Metrics getMetrics() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Metrics metrics = this.delegate.getMetrics();
            return metrics;
        }
    }

    public void deleteRows(Block rowIds) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.deleteRows(rowIds);
        }
    }

    public void updateRows(Page page, List<Integer> columnValueAndRowIdChannels) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.updateRows(page, columnValueAndRowIdChannels);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.finish();
            return completableFuture;
        }
    }

    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

