/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.CachingPath;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseHoodieTableFileIndex
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(BaseHoodieTableFileIndex.class);
    private final String[] partitionColumns;
    protected final HoodieMetadataConfig metadataConfig;
    private final HoodieTableQueryType queryType;
    private final Option<String> specifiedQueryInstant;
    protected final List<Path> queryPaths;
    private final boolean shouldIncludePendingCommits;
    private final boolean shouldValidateInstant;
    private final HoodieTableType tableType;
    protected final Path basePath;
    private final HoodieTableMetaClient metaClient;
    private final HoodieEngineContext engineContext;
    private final transient FileStatusCache fileStatusCache;
    protected volatile transient long cachedFileSize = 0L;
    protected volatile transient Map<PartitionPath, List<FileSlice>> cachedAllInputFileSlices;
    protected volatile boolean queryAsNonePartitionedTable = false;
    private volatile transient HoodieTableFileSystemView fileSystemView = null;
    private transient HoodieTableMetadata tableMetadata = null;

    public BaseHoodieTableFileIndex(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, TypedProperties configProperties, HoodieTableQueryType queryType, List<Path> queryPaths, Option<String> specifiedQueryInstant, boolean shouldIncludePendingCommits, boolean shouldValidateInstant, FileStatusCache fileStatusCache) {
        this.partitionColumns = metaClient.getTableConfig().getPartitionFields().orElse(new String[0]);
        this.metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(configProperties).build();
        this.queryType = queryType;
        this.queryPaths = queryPaths;
        this.specifiedQueryInstant = specifiedQueryInstant;
        this.shouldIncludePendingCommits = shouldIncludePendingCommits;
        this.shouldValidateInstant = shouldValidateInstant;
        this.tableType = metaClient.getTableType();
        this.basePath = metaClient.getBasePathV2();
        this.metaClient = metaClient;
        this.engineContext = engineContext;
        this.fileStatusCache = fileStatusCache;
        this.doRefresh();
    }

    protected abstract Object[] parsePartitionColumnValues(String[] var1, String var2);

    public Option<HoodieInstant> getLatestCompletedInstant() {
        return this.getActiveTimeline().filterCompletedInstants().lastInstant();
    }

    public String getBasePath() {
        return this.basePath.toString();
    }

    public Map<String, List<FileSlice>> listFileSlices() {
        return this.cachedAllInputFileSlices.entrySet().stream().collect(Collectors.toMap(e -> ((PartitionPath)e.getKey()).path, Map.Entry::getValue));
    }

    public int getFileSlicesCount() {
        return this.cachedAllInputFileSlices.values().stream().mapToInt(List::size).sum();
    }

    @Override
    public void close() throws Exception {
        this.resetTableMetadata(null);
    }

    protected List<PartitionPath> getAllQueryPartitionPaths() {
        List queryRelativePartitionPaths = this.queryPaths.stream().map(path -> FSUtils.getRelativePartitionPath(this.basePath, path)).collect(Collectors.toList());
        List matchedPartitionPaths = this.getAllPartitionPathsUnchecked().stream().filter(path -> queryRelativePartitionPaths.stream().anyMatch(path::startsWith)).collect(Collectors.toList());
        return matchedPartitionPaths.stream().map(partitionPath -> {
            Object[] partitionColumnValues = this.parsePartitionColumnValues(this.partitionColumns, (String)partitionPath);
            return new PartitionPath((String)partitionPath, partitionColumnValues);
        }).collect(Collectors.toList());
    }

    protected void refresh() {
        this.fileStatusCache.invalidate();
        this.doRefresh();
    }

    protected HoodieTimeline getActiveTimeline() {
        HoodieTimeline timeline = this.metaClient.getCommitsAndCompactionTimeline();
        if (this.shouldIncludePendingCommits) {
            return timeline;
        }
        return timeline.filterCompletedAndCompactionInstants();
    }

    private Map<PartitionPath, FileStatus[]> loadPartitionPathFiles() {
        Map<PartitionPath, FileStatus[]> fetchedPartitionToFiles;
        ArrayList pathToFetch = new ArrayList();
        HashMap cachedPartitionToFiles = new HashMap();
        List<PartitionPath> partitionPaths = this.getAllQueryPartitionPaths();
        partitionPaths.forEach(partitionPath -> {
            Option<FileStatus[]> filesInPartition = this.fileStatusCache.get(partitionPath.fullPartitionPath(this.basePath));
            if (filesInPartition.isPresent()) {
                cachedPartitionToFiles.put(partitionPath, filesInPartition.get());
            } else {
                pathToFetch.add(partitionPath);
            }
        });
        if (pathToFetch.isEmpty()) {
            fetchedPartitionToFiles = Collections.emptyMap();
        } else {
            Map fullPartitionPathsMapToFetch = pathToFetch.stream().collect(Collectors.toMap(partitionPath -> partitionPath.fullPartitionPath(this.basePath).toString(), Function.identity()));
            fetchedPartitionToFiles = this.getAllFilesInPartitionsUnchecked(fullPartitionPathsMapToFetch.keySet()).entrySet().stream().collect(Collectors.toMap(e -> (PartitionPath)fullPartitionPathsMapToFetch.get(e.getKey()), e -> (FileStatus[])e.getValue()));
        }
        fetchedPartitionToFiles.forEach((partitionPath, filesInPartition) -> this.fileStatusCache.put(partitionPath.fullPartitionPath(this.basePath), (FileStatus[])filesInPartition));
        return CollectionUtils.combine(cachedPartitionToFiles, fetchedPartitionToFiles);
    }

    private void doRefresh() {
        long startTime = System.currentTimeMillis();
        HoodieTableMetadata newTableMetadata = HoodieTableMetadata.create(this.engineContext, this.metadataConfig, this.basePath.toString(), FileSystemViewStorageConfig.SPILLABLE_DIR.defaultValue());
        this.resetTableMetadata(newTableMetadata);
        Map<PartitionPath, FileStatus[]> partitionFiles = this.loadPartitionPathFiles();
        FileStatus[] allFiles = (FileStatus[])partitionFiles.values().stream().flatMap(Arrays::stream).toArray(FileStatus[]::new);
        this.metaClient.reloadActiveTimeline();
        HoodieTimeline activeTimeline = this.getActiveTimeline();
        Option<HoodieInstant> latestInstant = activeTimeline.lastInstant();
        this.fileSystemView = new HoodieTableFileSystemView(this.metaClient, activeTimeline, allFiles);
        Option<String> queryInstant = this.specifiedQueryInstant.or(() -> latestInstant.map(HoodieInstant::getTimestamp));
        this.validate(activeTimeline, queryInstant);
        this.cachedAllInputFileSlices = partitionFiles.keySet().stream().collect(Collectors.toMap(Function.identity(), partitionPath -> queryInstant.map(instant -> this.fileSystemView.getLatestMergedFileSlicesBeforeOrOn(partitionPath.path, (String)queryInstant.get())).orElse(this.fileSystemView.getLatestFileSlices(partitionPath.path)).collect(Collectors.toList())));
        this.cachedFileSize = this.cachedAllInputFileSlices.values().stream().flatMap(Collection::stream).mapToLong(BaseHoodieTableFileIndex::fileSliceSize).sum();
        this.queryAsNonePartitionedTable = partitionFiles.keySet().stream().anyMatch(p -> p.values.length == 0);
        long duration = System.currentTimeMillis() - startTime;
        LOG.info((Object)String.format("Refresh table %s, spent: %d ms", this.metaClient.getTableConfig().getTableName(), duration));
    }

    private Map<String, FileStatus[]> getAllFilesInPartitionsUnchecked(Collection<String> fullPartitionPathsMapToFetch) {
        try {
            return this.tableMetadata.getAllFilesInPartitions(new ArrayList<String>(fullPartitionPathsMapToFetch));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to list partition paths for a table", e);
        }
    }

    private List<String> getAllPartitionPathsUnchecked() {
        try {
            return this.isPartitionedTable() ? this.tableMetadata.getAllPartitionPaths() : Collections.singletonList("");
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to fetch partition paths for a table", e);
        }
    }

    private void validate(HoodieTimeline activeTimeline, Option<String> queryInstant) {
        if (this.shouldValidateInstant && queryInstant.isPresent() && !activeTimeline.containsInstant(queryInstant.get())) {
            throw new HoodieIOException(String.format("Query instant (%s) not found in the timeline", queryInstant.get()));
        }
    }

    private static long fileSliceSize(FileSlice fileSlice) {
        long logFileSize = fileSlice.getLogFiles().map(HoodieLogFile::getFileSize).filter(s -> s > 0L).reduce(0L, Long::sum);
        return fileSlice.getBaseFile().map(BaseFile::getFileLen).orElse(0L) + logFileSize;
    }

    private void resetTableMetadata(HoodieTableMetadata newTableMetadata) {
        if (this.tableMetadata != null) {
            try {
                this.tableMetadata.close();
            }
            catch (Exception e) {
                throw new HoodieException("Failed to close HoodieTableMetadata instance", e);
            }
        }
        this.tableMetadata = newTableMetadata;
    }

    private boolean isPartitionedTable() {
        return this.partitionColumns.length > 0 || HoodieTableMetadata.isMetadataTable(this.basePath.toString());
    }

    protected static interface FileStatusCache {
        public Option<FileStatus[]> get(Path var1);

        public void put(Path var1, FileStatus[] var2);

        public void invalidate();
    }

    public static final class PartitionPath {
        final String path;
        final Object[] values;

        public PartitionPath(String path, Object[] values) {
            this.path = path;
            this.values = values;
        }

        public String getPath() {
            return this.path;
        }

        Path fullPartitionPath(Path basePath) {
            if (!this.path.isEmpty()) {
                return new CachingPath(basePath, (Path)CachingPath.createPathUnsafe(this.path));
            }
            return basePath;
        }

        public boolean equals(Object other) {
            return other instanceof PartitionPath && Objects.equals(this.path, ((PartitionPath)other).path) && Arrays.equals(this.values, ((PartitionPath)other).values);
        }

        public int hashCode() {
            return this.path.hashCode() * 1103 + Arrays.hashCode(this.values);
        }
    }
}

