/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import io.trino.orc.StreamId;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.Stream;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.ByteArrayInputStream;
import io.trino.orc.stream.ByteInputStream;
import io.trino.orc.stream.DecimalInputStream;
import io.trino.orc.stream.DoubleInputStream;
import io.trino.orc.stream.FloatInputStream;
import io.trino.orc.stream.LongInputStreamV1;
import io.trino.orc.stream.LongInputStreamV2;
import io.trino.orc.stream.OrcChunkLoader;
import io.trino.orc.stream.OrcInputStream;
import io.trino.orc.stream.ValueInputStream;

public final class ValueStreams {
    private ValueStreams() {
    }

    public static ValueInputStream<?> createValueStreams(StreamId streamId, OrcChunkLoader chunkLoader, OrcType.OrcTypeKind type, ColumnEncoding.ColumnEncodingKind encoding) {
        if (streamId.getStreamKind() == Stream.StreamKind.PRESENT) {
            return new BooleanInputStream(new OrcInputStream(chunkLoader));
        }
        if (!(encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY && encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2 || streamId.getStreamKind() != Stream.StreamKind.LENGTH && streamId.getStreamKind() != Stream.StreamKind.DATA)) {
            return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, false);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DATA) {
            switch (type) {
                case BOOLEAN: {
                    return new BooleanInputStream(new OrcInputStream(chunkLoader));
                }
                case BYTE: {
                    return new ByteInputStream(new OrcInputStream(chunkLoader));
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, true);
                }
                case FLOAT: {
                    return new FloatInputStream(new OrcInputStream(chunkLoader));
                }
                case DOUBLE: {
                    return new DoubleInputStream(new OrcInputStream(chunkLoader));
                }
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(new OrcInputStream(chunkLoader));
                }
                case TIMESTAMP: 
                case TIMESTAMP_INSTANT: {
                    return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, true);
                }
                case DECIMAL: {
                    return new DecimalInputStream(chunkLoader);
                }
                case UNION: {
                    return new ByteInputStream(new OrcInputStream(chunkLoader));
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: 
                case LIST: 
                case MAP: {
                    return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, false);
                }
            }
        }
        if ((type == OrcType.OrcTypeKind.TIMESTAMP || type == OrcType.OrcTypeKind.TIMESTAMP_INSTANT) && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, false);
        }
        if (type == OrcType.OrcTypeKind.DECIMAL && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(new OrcInputStream(chunkLoader), encoding, true);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(new OrcInputStream(chunkLoader));
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported column type %s for stream %s with encoding %s", new Object[]{type, streamId, encoding}));
    }

    private static ValueInputStream<?> createLongStream(OrcInputStream inputStream, ColumnEncoding.ColumnEncodingKind encoding, boolean signed) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongInputStreamV2(inputStream, signed, false);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongInputStreamV1(inputStream, signed);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + encoding);
    }
}

