/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;

public final class HiveCompressionCodecs {
    private HiveCompressionCodecs() {
    }

    public static HiveCompressionCodec selectCompressionCodec(ConnectorSession session, StorageFormat storageFormat) {
        HiveCompressionOption compressionOption = HiveSessionProperties.getCompressionCodec(session);
        return HiveStorageFormat.getHiveStorageFormat(storageFormat).map(format -> HiveCompressionCodecs.selectCompressionCodec(compressionOption, format)).orElse(HiveCompressionCodecs.selectCompressionCodecForUnknownStorageFormat(compressionOption));
    }

    public static HiveCompressionCodec selectCompressionCodec(ConnectorSession session, HiveStorageFormat storageFormat) {
        return HiveCompressionCodecs.selectCompressionCodec(HiveSessionProperties.getCompressionCodec(session), storageFormat);
    }

    public static HiveCompressionCodec selectCompressionCodec(HiveCompressionOption compressionOption, HiveStorageFormat storageFormat) {
        HiveCompressionCodec selectedCodec = HiveCompressionCodecs.selectCompressionCodec(compressionOption);
        if (storageFormat == HiveStorageFormat.AVRO && selectedCodec.getAvroCompressionCodec().isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec " + selectedCodec + " not supported for " + storageFormat);
        }
        return selectedCodec;
    }

    private static HiveCompressionCodec selectCompressionCodec(HiveCompressionOption compressionOption) {
        switch (compressionOption) {
            case NONE: {
                return HiveCompressionCodec.NONE;
            }
            case SNAPPY: {
                return HiveCompressionCodec.SNAPPY;
            }
            case LZ4: {
                return HiveCompressionCodec.LZ4;
            }
            case ZSTD: {
                return HiveCompressionCodec.ZSTD;
            }
            case GZIP: {
                return HiveCompressionCodec.GZIP;
            }
        }
        throw new IllegalArgumentException("Unknown compressionOption " + compressionOption);
    }

    private static HiveCompressionCodec selectCompressionCodecForUnknownStorageFormat(HiveCompressionOption compressionOption) {
        switch (compressionOption) {
            case NONE: {
                return HiveCompressionCodec.NONE;
            }
            case SNAPPY: {
                return HiveCompressionCodec.SNAPPY;
            }
            case LZ4: {
                return HiveCompressionCodec.LZ4;
            }
            case ZSTD: {
                return HiveCompressionCodec.ZSTD;
            }
            case GZIP: {
                return HiveCompressionCodec.GZIP;
            }
        }
        throw new IllegalArgumentException("Unknown compressionOption " + compressionOption);
    }
}

