/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.ForHiveTransactionHeartbeats;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveMaterializedViewMetadataFactory;
import io.trino.plugin.hive.HiveMetadata;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveRedirectionsProvider;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.aws.athena.PartitionProjectionService;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryLister;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class HiveMetadataFactory
implements TransactionalMetadataFactory {
    private final CatalogName catalogName;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean translateHiveViews;
    private final boolean hiveViewsRunAsInvoker;
    private final boolean hideDeltaLakeTables;
    private final long perTransactionCacheMaximumSize;
    private final HiveMetastoreFactory metastoreFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final MetadataProvider metadataProvider;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;
    private final BoundedExecutor dropExecutor;
    private final Executor updateExecutor;
    private final long maxPartitionDropsPerQuery;
    private final String trinoVersion;
    private final HiveRedirectionsProvider hiveRedirectionsProvider;
    private final Set<SystemTableProvider> systemTableProviders;
    private final HiveMaterializedViewMetadataFactory hiveMaterializedViewMetadataFactory;
    private final AccessControlMetadataFactory accessControlMetadataFactory;
    private final Optional<Duration> hiveTransactionHeartbeatInterval;
    private final ScheduledExecutorService heartbeatService;
    private final DirectoryLister directoryLister;
    private final long perTransactionFileStatusCacheMaximumSize;
    private final PartitionProjectionService partitionProjectionService;
    private final boolean allowTableRename;

    @Inject
    public HiveMetadataFactory(CatalogName catalogName, HiveConfig hiveConfig, HiveMetastoreConfig hiveMetastoreConfig, HiveMetastoreFactory metastoreFactory, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, ExecutorService executorService, @ForHiveTransactionHeartbeats ScheduledExecutorService heartbeatService, TypeManager typeManager, MetadataProvider metadataProvider, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, NodeVersion nodeVersion, HiveRedirectionsProvider hiveRedirectionsProvider, Set<SystemTableProvider> systemTableProviders, HiveMaterializedViewMetadataFactory hiveMaterializedViewMetadataFactory, AccessControlMetadataFactory accessControlMetadataFactory, DirectoryLister directoryLister, PartitionProjectionService partitionProjectionService, @AllowHiveTableRename boolean allowTableRename) {
        this(catalogName, metastoreFactory, hdfsEnvironment, partitionManager, hiveConfig.getMaxConcurrentFileRenames(), hiveConfig.getMaxConcurrentMetastoreDrops(), hiveConfig.getMaxConcurrentMetastoreUpdates(), hiveConfig.getMaxPartitionDropsPerQuery(), hiveConfig.isSkipDeletionForAlter(), hiveConfig.isSkipTargetCleanupOnRollback(), hiveConfig.getWritesToNonManagedTablesEnabled(), hiveConfig.getCreatesOfNonManagedTablesEnabled(), hiveConfig.isDeleteSchemaLocationsFallback(), hiveConfig.isTranslateHiveViews(), hiveConfig.isHiveViewsRunAsInvoker(), hiveConfig.getPerTransactionMetastoreCacheMaximumSize(), hiveConfig.getHiveTransactionHeartbeatInterval(), hiveMetastoreConfig.isHideDeltaLakeTables(), typeManager, metadataProvider, locationService, partitionUpdateCodec, executorService, heartbeatService, nodeVersion.toString(), hiveRedirectionsProvider, systemTableProviders, hiveMaterializedViewMetadataFactory, accessControlMetadataFactory, directoryLister, hiveConfig.getPerTransactionFileStatusCacheMaximumSize(), partitionProjectionService, allowTableRename);
    }

    public HiveMetadataFactory(CatalogName catalogName, HiveMetastoreFactory metastoreFactory, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, int maxConcurrentFileRenames, int maxConcurrentMetastoreDrops, int maxConcurrentMetastoreUpdates, long maxPartitionDropsPerQuery, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean deleteSchemaLocationsFallback, boolean translateHiveViews, boolean hiveViewsRunAsInvoker, long perTransactionCacheMaximumSize, Optional<Duration> hiveTransactionHeartbeatInterval, boolean hideDeltaLakeTables, TypeManager typeManager, MetadataProvider metadataProvider, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService, ScheduledExecutorService heartbeatService, String trinoVersion, HiveRedirectionsProvider hiveRedirectionsProvider, Set<SystemTableProvider> systemTableProviders, HiveMaterializedViewMetadataFactory hiveMaterializedViewMetadataFactory, AccessControlMetadataFactory accessControlMetadataFactory, DirectoryLister directoryLister, long perTransactionFileStatusCacheMaximumSize, PartitionProjectionService partitionProjectionService, boolean allowTableRename) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.translateHiveViews = translateHiveViews;
        this.hiveViewsRunAsInvoker = hiveViewsRunAsInvoker;
        this.hideDeltaLakeTables = hideDeltaLakeTables;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metadataProvider = Objects.requireNonNull(metadataProvider, "metadataProvider is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.hiveRedirectionsProvider = Objects.requireNonNull(hiveRedirectionsProvider, "hiveRedirectionsProvider is null");
        this.systemTableProviders = Objects.requireNonNull(systemTableProviders, "systemTableProviders is null");
        this.hiveMaterializedViewMetadataFactory = Objects.requireNonNull(hiveMaterializedViewMetadataFactory, "hiveMaterializedViewMetadataFactory is null");
        this.accessControlMetadataFactory = Objects.requireNonNull(accessControlMetadataFactory, "accessControlMetadataFactory is null");
        this.hiveTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
        this.dropExecutor = new BoundedExecutor((Executor)executorService, maxConcurrentMetastoreDrops);
        this.updateExecutor = maxConcurrentMetastoreUpdates == 1 ? MoreExecutors.directExecutor() : new BoundedExecutor((Executor)executorService, maxConcurrentMetastoreUpdates);
        this.maxPartitionDropsPerQuery = maxPartitionDropsPerQuery;
        this.heartbeatService = Objects.requireNonNull(heartbeatService, "heartbeatService is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.perTransactionFileStatusCacheMaximumSize = perTransactionFileStatusCacheMaximumSize;
        this.partitionProjectionService = Objects.requireNonNull(partitionProjectionService, "partitionProjectionService is null");
        this.allowTableRename = allowTableRename;
    }

    @Override
    public TransactionalMetadata create(ConnectorIdentity identity, boolean autoCommit) {
        HiveMetastoreClosure hiveMetastoreClosure = new HiveMetastoreClosure(CachingHiveMetastore.memoizeMetastore(this.metastoreFactory.createMetastore(Optional.of(identity)), this.perTransactionCacheMaximumSize));
        TransactionScopeCachingDirectoryLister directoryLister = new TransactionScopeCachingDirectoryLister(this.directoryLister, this.perTransactionFileStatusCacheMaximumSize);
        SemiTransactionalHiveMetastore metastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, hiveMetastoreClosure, (Executor)this.renameExecution, (Executor)this.dropExecutor, this.updateExecutor, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback, this.deleteSchemaLocationsFallback, this.hiveTransactionHeartbeatInterval, this.heartbeatService, directoryLister);
        return new HiveMetadata(this.catalogName, metastore, autoCommit, this.hdfsEnvironment, this.partitionManager, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.translateHiveViews, this.hiveViewsRunAsInvoker, this.hideDeltaLakeTables, this.typeManager, this.metadataProvider, this.locationService, this.partitionUpdateCodec, this.trinoVersion, new MetastoreHiveStatisticsProvider(metastore), this.hiveRedirectionsProvider, this.systemTableProviders, this.hiveMaterializedViewMetadataFactory.create(hiveMetastoreClosure), this.accessControlMetadataFactory.create(metastore), directoryLister, this.partitionProjectionService, this.allowTableRename, this.maxPartitionDropsPerQuery);
    }
}

