/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HivePartitionedBucketFunction
implements BucketFunction {
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int hiveBucketCount;
    private final List<TypeInfo> bucketTypeInfos;
    private final int bucketCount;
    private final int firstPartitionColumnIndex;
    private final List<MethodHandle> hashCodeInvokers;

    public HivePartitionedBucketFunction(HiveBucketing.BucketingVersion bucketingVersion, int hiveBucketCount, List<HiveType> hiveBucketTypes, List<Type> partitionColumnsTypes, TypeOperators typeOperators, int bucketCount) {
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.hiveBucketCount = hiveBucketCount;
        this.bucketTypeInfos = (List)hiveBucketTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        this.firstPartitionColumnIndex = hiveBucketTypes.size();
        this.hashCodeInvokers = (List)partitionColumnsTypes.stream().map(type -> typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).collect(ImmutableList.toImmutableList());
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        long partitionHash = 0L;
        for (int i = 0; i < this.hashCodeInvokers.size(); ++i) {
            try {
                Block partitionColumn = page.getBlock(i + this.firstPartitionColumnIndex);
                partitionHash = 31L * partitionHash + HivePartitionedBucketFunction.hashCodeNullSafe(this.hashCodeInvokers.get(i), partitionColumn, position);
                continue;
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
        }
        int hiveBucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.hiveBucketCount, this.bucketTypeInfos, page, position);
        return (int)((31L * partitionHash + (long)hiveBucket & Long.MAX_VALUE) % (long)this.bucketCount);
    }

    private static long hashCodeNullSafe(MethodHandle hashCode, Block block, int position) throws Throwable {
        if (block.isNull(position)) {
            return -1L;
        }
        return hashCode.invokeExact(block, position);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.bucketingVersion).add("hiveBucketCount", this.hiveBucketCount).add("bucketTypeInfos", this.bucketTypeInfos).add("firstPartitionColumnIndex", this.firstPartitionColumnIndex).add("bucketCount", this.bucketCount).toString();
    }
}

