/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.AbstractHiveAcidWriters;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionUpdateAndMergeResults;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MergePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class MergeFileWriter
extends AbstractHiveAcidWriters
implements FileWriter {
    private final String partitionName;
    private final List<HiveColumnHandle> inputColumns;
    private int deleteRowCount;
    private int insertRowCount;

    public MergeFileWriter(AcidTransaction transaction, int statementId, OptionalInt bucketNumber, HiveWriterFactory.RowIdSortingFileWriterMaker sortingFileWriterMaker, Path bucketPath, Optional<String> partitionName, OrcFileWriterFactory orcFileWriterFactory, List<HiveColumnHandle> inputColumns, Configuration configuration, ConnectorSession session, TypeManager typeManager, HiveType hiveRowType) {
        super(transaction, statementId, bucketNumber, Optional.of(sortingFileWriterMaker), bucketPath, false, orcFileWriterFactory, configuration, session, typeManager, hiveRowType, AcidOperation.MERGE);
        this.partitionName = partitionName.orElse("");
        this.inputColumns = Objects.requireNonNull(inputColumns, "inputColumns is null");
    }

    @Override
    public void appendRows(Page page) {
        if (page.getPositionCount() == 0) {
            return;
        }
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.inputColumns.size());
        mergePage.getDeletionsPage().ifPresent(deletePage -> {
            Block acidBlock = deletePage.getBlock(deletePage.getChannelCount() - 1);
            Page orcDeletePage = this.buildDeletePage(acidBlock, this.transaction.getWriteId());
            this.getOrCreateDeleteFileWriter().appendRows(orcDeletePage);
            this.deleteRowCount += deletePage.getPositionCount();
        });
        mergePage.getInsertionsPage().ifPresent(insertPage -> {
            Page orcInsertPage = MergeFileWriter.buildInsertPage(insertPage, this.transaction.getWriteId(), this.inputColumns, this.bucketValueBlock, this.insertRowCount);
            this.insertRowCount += insertPage.getPositionCount();
            this.getOrCreateInsertFileWriter().appendRows(orcInsertPage);
            this.insertRowCount += insertPage.getPositionCount();
        });
    }

    @VisibleForTesting
    public static Page buildInsertPage(Page insertPage, long writeId, List<HiveColumnHandle> columns, Block bucketValueBlock, int insertRowCount) {
        int positionCount = insertPage.getPositionCount();
        List dataColumns = (List)columns.stream().filter(column -> !column.isPartitionKey() && !column.isHidden()).map(column -> insertPage.getBlock(column.getBaseHiveColumnIndex())).collect(ImmutableList.toImmutableList());
        Block mergedColumnsBlock = RowBlock.fromFieldBlocks((int)positionCount, Optional.empty(), (Block[])dataColumns.toArray(new Block[0]));
        Block currentTransactionBlock = RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)writeId, (int)positionCount);
        Block[] blockArray = new Block[]{RunLengthEncodedBlock.create((Block)INSERT_OPERATION_BLOCK, (int)positionCount), currentTransactionBlock, RunLengthEncodedBlock.create((Block)bucketValueBlock, (int)positionCount), MergeFileWriter.createRowIdBlock(positionCount, insertRowCount), currentTransactionBlock, mergedColumnsBlock};
        return new Page(blockArray);
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    @Override
    public long getWrittenBytes() {
        return this.deleteFileWriter.map(FileWriter::getWrittenBytes).orElse(0L) + this.insertFileWriter.map(FileWriter::getWrittenBytes).orElse(0L);
    }

    @Override
    public long getMemoryUsage() {
        return this.deleteFileWriter.map(FileWriter::getMemoryUsage).orElse(0L) + this.insertFileWriter.map(FileWriter::getMemoryUsage).orElse(0L);
    }

    @Override
    public void commit() {
        this.deleteFileWriter.ifPresent(FileWriter::commit);
        this.insertFileWriter.ifPresent(FileWriter::commit);
    }

    @Override
    public void rollback() {
        try {
            this.deleteFileWriter.ifPresent(FileWriter::rollback);
        }
        finally {
            this.insertFileWriter.ifPresent(FileWriter::rollback);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.deleteFileWriter.map(FileWriter::getValidationCpuNanos).orElse(0L) + this.insertFileWriter.map(FileWriter::getValidationCpuNanos).orElse(0L);
    }

    public PartitionUpdateAndMergeResults getPartitionUpdateAndMergeResults(PartitionUpdate partitionUpdate) {
        return new PartitionUpdateAndMergeResults(partitionUpdate, this.insertRowCount, this.insertFileWriter.isPresent() ? Optional.of(this.deltaDirectory.toString()) : Optional.empty(), this.deleteRowCount, this.deleteFileWriter.isPresent() ? Optional.of(this.deleteDeltaDirectory.toString()) : Optional.empty());
    }
}

