/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.thrift.TException;

public class UgiBasedMetastoreClientFactory
implements IdentityAwareMetastoreClientFactory {
    private final TokenAwareMetastoreClientFactory clientProvider;
    private final boolean impersonationEnabled;

    @Inject
    public UgiBasedMetastoreClientFactory(TokenAwareMetastoreClientFactory clientProvider, ThriftMetastoreConfig thriftConfig) {
        this.clientProvider = Objects.requireNonNull(clientProvider, "clientProvider is null");
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
    }

    @Override
    public ThriftMetastoreClient createMetastoreClientFor(Optional<ConnectorIdentity> identity) throws TException {
        ThriftMetastoreClient client = this.clientProvider.createMetastoreClient(Optional.empty());
        if (this.impersonationEnabled) {
            String username = identity.map(ConnectorIdentity::getUser).orElseThrow(() -> new IllegalStateException("End-user name should exist when metastore impersonation is enabled"));
            UgiBasedMetastoreClientFactory.setMetastoreUserOrClose(client, username);
        }
        return client;
    }

    private static void setMetastoreUserOrClose(ThriftMetastoreClient client, String username) throws TException {
        try {
            client.setUGI(username);
        }
        catch (Throwable t) {
            try {
                ThriftMetastoreClient ignored = client;
                try {
                    throw t;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

