/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class ParquetFileWriter
implements FileWriter {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(ParquetFileWriter.class).instanceSize());
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final ParquetWriter parquetWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<ParquetDataSource>> validationInputFactory;
    private long validationCpuNanos;

    public ParquetFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, List<Type> fileColumnTypes, List<String> fileColumnNames, MessageType messageType, Map<List<String>, Type> primitiveTypes, ParquetWriterOptions parquetWriterOptions, int[] fileInputColumnIndexes, CompressionCodecName compressionCodecName, String trinoVersion, Optional<DateTimeZone> parquetTimeZone, Optional<Supplier<ParquetDataSource>> validationInputFactory) {
        Objects.requireNonNull(outputStream, "outputStream is null");
        Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.validationInputFactory = Objects.requireNonNull(validationInputFactory, "validationInputFactory is null");
        this.parquetWriter = new ParquetWriter(outputStream, messageType, primitiveTypes, parquetWriterOptions, compressionCodecName, trinoVersion, parquetTimeZone, validationInputFactory.isPresent() ? Optional.of(new ParquetWriteValidation.ParquetWriteValidationBuilder(fileColumnTypes, fileColumnNames)) : Optional.empty());
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "fileInputColumnIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            nullBlocks.add((Object)blockBuilder.build());
        }
        this.nullBlocks = nullBlocks.build();
    }

    @Override
    public long getWrittenBytes() {
        return this.parquetWriter.getWrittenBytes() + this.parquetWriter.getBufferedBytes();
    }

    @Override
    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.parquetWriter.getRetainedBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? RunLengthEncodedBlock.create((Block)this.nullBlocks.get(i), (int)dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.parquetWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commit() {
        try {
            this.parquetWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write parquet to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (ParquetDataSource input = this.validationInputFactory.get().get();){
                long startThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                this.parquetWriter.validate(input);
                this.validationCpuNanos += THREAD_MX_BEAN.getCurrentThreadCpuTime() - startThreadCpuTime;
            }
            catch (IOException | UncheckedIOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.parquetWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write parquet to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.parquetWriter).toString();
    }
}

