/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.RemovalCause;
import com.google.shaded.shaded.common.hash.BloomFilter;
import com.google.shaded.shaded.common.util.concurrent.Striped;
import com.qubole.rubix.bookkeeper.ByteBufferBitmap;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class FileMetadata {
    private final String remotePath;
    private final String localPath;
    private final String mdFilePath;
    private final long size;
    private final long lastModified;
    private long currentFileSize;
    private boolean needsRefresh = true;
    private final int generationNumber;
    int bitmapFileSizeBytes;
    ByteBufferBitmap blockBitmap;
    private static final Striped<Lock> stripes = Striped.lock(20000);
    private static final Log log = LogFactory.getLog((String)FileMetadata.class.getName());

    public FileMetadata(String remotePath, long fileLength, long lastModified, long currentFileSize, Configuration conf, Cache<String, Integer> generationNumberCache, BloomFilter fileAccessedBloomFilter) throws ExecutionException, IOException {
        this(remotePath, fileLength, lastModified, currentFileSize, conf, FileMetadata.findGenerationNumber(remotePath, conf, generationNumberCache, fileAccessedBloomFilter));
        this.createLocalFiles();
    }

    public FileMetadata(String remotePath, long fileLength, long lastModified, long currentFileSize, Configuration conf, int generationNumber) {
        this.remotePath = remotePath;
        this.size = fileLength;
        this.lastModified = lastModified;
        this.currentFileSize = currentFileSize;
        this.generationNumber = generationNumber;
        this.localPath = CacheUtil.getLocalPath(remotePath, conf, generationNumber);
        this.mdFilePath = CacheUtil.getMetadataFilePath(remotePath, conf, generationNumber);
        int bitsRequired = (int)Math.ceil((double)this.size / (double)CacheConfig.getBlockSize(conf));
        this.bitmapFileSizeBytes = (int)Math.ceil((double)bitsRequired / 8.0);
    }

    private void createLocalFiles() throws IOException {
        log.debug((Object)String.format("Creating Local Files %s and %s ", this.localPath, this.mdFilePath));
        File file = new File(this.localPath);
        file.createNewFile();
        file.setWritable(true, false);
        file.setReadable(true, false);
        file = new File(this.mdFilePath);
        file.createNewFile();
        file.setWritable(true, false);
        file.setReadable(true, false);
    }

    private static int findGenerationNumber(String remotePath, Configuration conf, Cache<String, Integer> generationNumberCache, BloomFilter fileAccessedBloomFilter) throws ExecutionException {
        int genNumber;
        if (CacheConfig.isDummyModeEnabled(conf)) {
            return 1;
        }
        if (!fileAccessedBloomFilter.mightContain(remotePath)) {
            int highestGenNumberOnDisk = 1;
            while (new File(CacheUtil.getLocalPath(remotePath, conf, highestGenNumberOnDisk)).exists() || new File(CacheUtil.getMetadataFilePath(remotePath, conf, highestGenNumberOnDisk)).exists()) {
                ++highestGenNumberOnDisk;
            }
            --highestGenNumberOnDisk;
            if (CacheConfig.isCleanupFilesDuringStartEnabled(conf)) {
                FileMetadata.addFilesForDeletion(highestGenNumberOnDisk, remotePath, conf);
                genNumber = highestGenNumberOnDisk + 1;
            } else if (highestGenNumberOnDisk == 0) {
                genNumber = 1;
            } else if (new File(CacheUtil.getLocalPath(remotePath, conf, highestGenNumberOnDisk)).exists() && new File(CacheUtil.getMetadataFilePath(remotePath, conf, highestGenNumberOnDisk)).exists()) {
                FileMetadata.addFilesForDeletion(highestGenNumberOnDisk - 1, remotePath, conf);
                genNumber = highestGenNumberOnDisk;
            } else {
                FileMetadata.addFilesForDeletion(highestGenNumberOnDisk, remotePath, conf);
                genNumber = highestGenNumberOnDisk + 1;
            }
            fileAccessedBloomFilter.put(remotePath);
        } else {
            genNumber = generationNumberCache.get(remotePath, () -> 0) + 1;
            while (new File(CacheUtil.getLocalPath(remotePath, conf, genNumber)).exists() || new File(CacheUtil.getMetadataFilePath(remotePath, conf, genNumber)).exists()) {
                ++genNumber;
            }
            FileMetadata.addFilesForDeletion(genNumber - 1, remotePath, conf);
        }
        generationNumberCache.put(remotePath, genNumber);
        return genNumber;
    }

    private static void addFilesForDeletion(int generationNumber, String remotePath, Configuration conf) {
        for (int i = 1; i <= generationNumber; ++i) {
            String localPath = CacheUtil.getLocalPath(remotePath, conf, i);
            String mdPath = CacheUtil.getMetadataFilePath(remotePath, conf, i);
            try {
                Files.delete(Paths.get(localPath, new String[0]));
            }
            catch (IOException e) {
                log.warn((Object)String.format("Exception while deleting old local file %s", localPath), (Throwable)e);
            }
            try {
                Files.delete(Paths.get(mdPath, new String[0]));
                continue;
            }
            catch (IOException e) {
                log.warn((Object)String.format("Exception while deleting old md file %s ", mdPath), (Throwable)e);
            }
        }
    }

    long incrementCurrentFileSize(long incrementBy) {
        this.currentFileSize += incrementBy;
        return this.currentFileSize;
    }

    @VisibleForTesting
    public long getCurrentFileSize() {
        return this.currentFileSize;
    }

    public void setNeedsRefresh() {
        this.needsRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshBitmap() throws IOException {
        byte[] bytes = new byte[this.bitmapFileSizeBytes];
        Lock lock = stripes.get(this.remotePath);
        try {
            RandomAccessFile mdFile;
            lock.lock();
            try {
                mdFile = new RandomAccessFile(this.mdFilePath, "rw");
                mdFile.readFully(bytes, 0, (int)mdFile.length());
            }
            catch (FileNotFoundException e) {
                File file = new File(this.mdFilePath);
                file.createNewFile();
                file.setWritable(true, false);
                file.setReadable(true, false);
                mdFile = new RandomAccessFile(file, "rw");
                mdFile.setLength(this.bitmapFileSizeBytes);
            }
            mdFile.close();
        }
        finally {
            lock.unlock();
        }
        this.blockBitmap = new ByteBufferBitmap(bytes);
        this.needsRefresh = false;
    }

    public boolean isBlockCached(long blockNumber) throws IOException {
        if (this.needsRefresh) {
            this.refreshBitmap();
        }
        return this.blockBitmap.isSet((int)blockNumber);
    }

    private void setBlockCached(long blockNumber) throws IOException {
        if (this.needsRefresh) {
            this.refreshBitmap();
        }
        this.blockBitmap.set((int)blockNumber);
    }

    public synchronized OptionalInt setBlocksCached(long startBlock, long endBlock) throws IOException {
        int numberOfBlocksUpdated = 0;
        for (long blockNum = startBlock; blockNum < endBlock; ++blockNum) {
            if (this.isBlockCached(blockNum)) continue;
            ++numberOfBlocksUpdated;
            this.setBlockCached(blockNum);
        }
        try {
            RandomAccessFile mdFile = new RandomAccessFile(this.mdFilePath, "rw");
            mdFile.write(this.blockBitmap.getBytes());
            mdFile.close();
        }
        catch (FileNotFoundException e) {
            numberOfBlocksUpdated = -1;
            log.error((Object)("Could not update mdfile for " + this.remotePath + ". Trying again"), (Throwable)e);
            try {
                this.refreshBitmap();
            }
            catch (IOException e1) {
                this.blockBitmap = new ByteBufferBitmap(new byte[this.bitmapFileSizeBytes]);
                log.error((Object)("Could not refresh mdfile in second try for " + this.remotePath), (Throwable)e);
            }
            log.warn((Object)("Updated mdfile successfully for " + this.remotePath));
        }
        catch (IOException e) {
            log.error((Object)("Could not update mdfile for " + this.remotePath), (Throwable)e);
            numberOfBlocksUpdated = -1;
        }
        return numberOfBlocksUpdated == -1 ? OptionalInt.empty() : OptionalInt.of(numberOfBlocksUpdated);
    }

    public void closeAndCleanup(RemovalCause cause, Cache cache) {
        if (cause != RemovalCause.REPLACED) {
            log.debug((Object)("Evicting " + this.getRemotePath() + " due to " + (Object)((Object)cause)));
            this.deleteFiles(cache);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @VisibleForTesting
    public String getMdFilePath() {
        return this.mdFilePath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getFileSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFiles(Cache<String, FileMetadata> cache) {
        Lock lock = stripes.get(this.getRemotePath());
        try {
            lock.lock();
            Files.delete(Paths.get(this.mdFilePath, new String[0]));
        }
        catch (IOException ex) {
            log.error((Object)String.format("Could not delete cached files %s", this.mdFilePath), (Throwable)ex);
        }
        try {
            Files.delete(Paths.get(this.localPath, new String[0]));
        }
        catch (IOException ex) {
            log.error((Object)String.format("Could not delete cached files %s", this.localPath), (Throwable)ex);
        }
        finally {
            lock.unlock();
        }
        FileMetadata newEntry = cache.getIfPresent(this.getRemotePath());
        if (newEntry != null) {
            newEntry.setNeedsRefresh();
        }
    }

    public int getWeight() {
        return Math.toIntExact(DataSizeUnits.BYTES.toKB(this.currentFileSize));
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }
}

