/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.SharedAccessPolicy;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.SharedAccessTablePermissions;
import java.util.EnumSet;

public final class SharedAccessTablePolicy
extends SharedAccessPolicy {
    private EnumSet<SharedAccessTablePermissions> permissions;

    public EnumSet<SharedAccessTablePermissions> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(EnumSet<SharedAccessTablePermissions> permissions) {
        this.permissions = permissions;
    }

    @Override
    public String permissionsToString() {
        if (this.permissions == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.permissions.contains((Object)SharedAccessTablePermissions.QUERY)) {
            builder.append("r");
        }
        if (this.permissions.contains((Object)SharedAccessTablePermissions.ADD)) {
            builder.append("a");
        }
        if (this.permissions.contains((Object)SharedAccessTablePermissions.UPDATE)) {
            builder.append("u");
        }
        if (this.permissions.contains((Object)SharedAccessTablePermissions.DELETE)) {
            builder.append("d");
        }
        return builder.toString();
    }

    @Override
    public void setPermissionsFromString(String value) {
        char[] chars = value.toCharArray();
        EnumSet<SharedAccessTablePermissions> retSet = EnumSet.noneOf(SharedAccessTablePermissions.class);
        block6: for (char c : chars) {
            switch (c) {
                case 'r': {
                    retSet.add(SharedAccessTablePermissions.QUERY);
                    continue block6;
                }
                case 'a': {
                    retSet.add(SharedAccessTablePermissions.ADD);
                    continue block6;
                }
                case 'u': {
                    retSet.add(SharedAccessTablePermissions.UPDATE);
                    continue block6;
                }
                case 'd': {
                    retSet.add(SharedAccessTablePermissions.DELETE);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Permissions could not be parsed from '%s'.", value));
                }
            }
        }
        this.permissions = retSet;
    }
}

