/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.configuration;

import io.prestosql.hadoop.$internal.org.apache.commons.configuration.AbstractConfiguration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.Configuration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.ConversionException;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration.PropertyConverter;
import io.prestosql.hadoop.$internal.org.apache.commons.lang.ClassUtils;
import io.prestosql.hadoop.$internal.org.apache.commons.lang.StringUtils;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class DataConfiguration
extends AbstractConfiguration
implements Serializable {
    public static final String DATE_FORMAT_KEY = "io.prestosql.hadoop.$internal.org.apache.commons.configuration.format.date";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long serialVersionUID = -69011336405718640L;
    protected Configuration configuration;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$awt$Color;

    public DataConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    protected void addPropertyDirect(String key, Object obj) {
        if (this.configuration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.configuration).addPropertyDirect(key, obj);
        } else {
            this.configuration.addProperty(key, obj);
        }
    }

    public void addProperty(String key, Object value) {
        this.getConfiguration().addProperty(key, value);
    }

    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.configuration.setProperty(key, value);
    }

    public Iterator getKeys() {
        return this.configuration.getKeys();
    }

    public Object get(Class cls, String key) {
        Object value = this.get(cls, key, null);
        if (value != null) {
            return value;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public Object get(Class cls, String key, Object defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            if ((class$java$util$Date == null ? (class$java$util$Date = DataConfiguration.class$("java.util.Date")) : class$java$util$Date).equals(cls) || (class$java$util$Calendar == null ? (class$java$util$Calendar = DataConfiguration.class$("java.util.Calendar")) : class$java$util$Calendar).equals(cls)) {
                return PropertyConverter.to(cls, this.interpolate(value), new String[]{this.getDefaultDateFormat()});
            }
            return PropertyConverter.to(cls, this.interpolate(value), null);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a " + cls, e);
        }
    }

    public List getList(Class cls, String key) {
        return this.getList(cls, key, new ArrayList());
    }

    public List getList(Class cls, String key, List defaultValue) {
        ArrayList<Object> list;
        Class<?> valueClass;
        Object value = this.getProperty(key);
        Class<?> clazz = valueClass = value != null ? value.getClass() : null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)value)) {
            list = defaultValue;
        } else {
            list = new ArrayList<Object>();
            Object[] params = null;
            if (cls.equals(class$java$util$Date == null ? (class$java$util$Date = DataConfiguration.class$("java.util.Date")) : class$java$util$Date) || cls.equals(class$java$util$Calendar == null ? (class$java$util$Calendar = DataConfiguration.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                params = new Object[]{this.getDefaultDateFormat()};
            }
            try {
                if (valueClass.isArray()) {
                    Class<?> arrayType = valueClass.getComponentType();
                    int length = Array.getLength(value);
                    if (arrayType.equals(cls) || arrayType.isPrimitive() && cls.equals(ClassUtils.primitiveToWrapper(arrayType))) {
                        for (int i = 0; i < length; ++i) {
                            list.add(Array.get(value, i));
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            list.add(PropertyConverter.to(cls, this.interpolate(Array.get(value, i)), params));
                        }
                    }
                } else if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    Iterator it = values.iterator();
                    while (it.hasNext()) {
                        list.add(PropertyConverter.to(cls, this.interpolate(it.next()), params));
                    }
                } else {
                    list.add(PropertyConverter.to(cls, this.interpolate(value), params));
                }
            }
            catch (ConversionException e) {
                throw new ConversionException("'" + key + "' doesn't map to a list of " + cls, e);
            }
        }
        return list;
    }

    public Object getArray(Class cls, String key) {
        return this.getArray(cls, key, Array.newInstance(cls, 0));
    }

    public Object getArray(Class cls, String key, Object defaultValue) {
        if (!(defaultValue == null || defaultValue.getClass().isArray() && cls.isAssignableFrom(defaultValue.getClass().getComponentType()))) {
            throw new IllegalArgumentException("The type of the default value (" + defaultValue.getClass() + ")" + " is not an array of the specified class (" + cls + ")");
        }
        if (cls.isPrimitive()) {
            return this.getPrimitiveArray(cls, key, defaultValue);
        }
        List list = this.getList(cls, key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray((Object[])Array.newInstance(cls, list.size()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getPrimitiveArray(Class cls, String key, Object defaultValue) {
        void var6_6;
        Object array;
        Class<?> valueClass;
        Object value = this.getProperty(key);
        Class<?> clazz = valueClass = value != null ? value.getClass() : null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)value)) {
            array = defaultValue;
            return var6_6;
        } else if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            int length = Array.getLength(value);
            if (arrayType.equals(cls)) {
                array = value;
                return var6_6;
            } else {
                if (!arrayType.equals(ClassUtils.primitiveToWrapper(cls))) throw new ConversionException('\'' + key + "' (" + arrayType + ")" + " doesn't map to a compatible array of " + cls);
                array = Array.newInstance(cls, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, Array.get(value, i));
                }
            }
            return var6_6;
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = Array.newInstance(cls, values.size());
            Iterator it = values.iterator();
            int i = 0;
            while (it.hasNext()) {
                Array.set(array, i++, PropertyConverter.to(cls, this.interpolate(it.next()), null));
            }
            return var6_6;
        } else {
            try {
                Object convertedValue = PropertyConverter.to(cls, this.interpolate(value), null);
                array = Array.newInstance(cls, 1);
                Array.set(array, 0, convertedValue);
                return var6_6;
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to an array of " + cls, e);
            }
        }
    }

    public List getBooleanList(String key) {
        return this.getBooleanList(key, new ArrayList());
    }

    public List getBooleanList(String key, List defaultValue) {
        return this.getList(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataConfiguration.class$("java.lang.Boolean")) : class$java$lang$Boolean, key, defaultValue);
    }

    public boolean[] getBooleanArray(String key) {
        return (boolean[])this.getArray(Boolean.TYPE, key);
    }

    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        return (boolean[])this.getArray(Boolean.TYPE, key, defaultValue);
    }

    public List getByteList(String key) {
        return this.getByteList(key, new ArrayList());
    }

    public List getByteList(String key, List defaultValue) {
        return this.getList(class$java$lang$Byte == null ? (class$java$lang$Byte = DataConfiguration.class$("java.lang.Byte")) : class$java$lang$Byte, key, defaultValue);
    }

    public byte[] getByteArray(String key) {
        return this.getByteArray(key, new byte[0]);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        return (byte[])this.getArray(Byte.TYPE, key, defaultValue);
    }

    public List getShortList(String key) {
        return this.getShortList(key, new ArrayList());
    }

    public List getShortList(String key, List defaultValue) {
        return this.getList(class$java$lang$Short == null ? (class$java$lang$Short = DataConfiguration.class$("java.lang.Short")) : class$java$lang$Short, key, defaultValue);
    }

    public short[] getShortArray(String key) {
        return this.getShortArray(key, new short[0]);
    }

    public short[] getShortArray(String key, short[] defaultValue) {
        return (short[])this.getArray(Short.TYPE, key, defaultValue);
    }

    public List getIntegerList(String key) {
        return this.getIntegerList(key, new ArrayList());
    }

    public List getIntegerList(String key, List defaultValue) {
        return this.getList(class$java$lang$Integer == null ? (class$java$lang$Integer = DataConfiguration.class$("java.lang.Integer")) : class$java$lang$Integer, key, defaultValue);
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, new int[0]);
    }

    public int[] getIntArray(String key, int[] defaultValue) {
        return (int[])this.getArray(Integer.TYPE, key, defaultValue);
    }

    public List getLongList(String key) {
        return this.getLongList(key, new ArrayList());
    }

    public List getLongList(String key, List defaultValue) {
        return this.getList(class$java$lang$Long == null ? (class$java$lang$Long = DataConfiguration.class$("java.lang.Long")) : class$java$lang$Long, key, defaultValue);
    }

    public long[] getLongArray(String key) {
        return this.getLongArray(key, new long[0]);
    }

    public long[] getLongArray(String key, long[] defaultValue) {
        return (long[])this.getArray(Long.TYPE, key, defaultValue);
    }

    public List getFloatList(String key) {
        return this.getFloatList(key, new ArrayList());
    }

    public List getFloatList(String key, List defaultValue) {
        return this.getList(class$java$lang$Float == null ? (class$java$lang$Float = DataConfiguration.class$("java.lang.Float")) : class$java$lang$Float, key, defaultValue);
    }

    public float[] getFloatArray(String key) {
        return this.getFloatArray(key, new float[0]);
    }

    public float[] getFloatArray(String key, float[] defaultValue) {
        return (float[])this.getArray(Float.TYPE, key, defaultValue);
    }

    public List getDoubleList(String key) {
        return this.getDoubleList(key, new ArrayList());
    }

    public List getDoubleList(String key, List defaultValue) {
        return this.getList(class$java$lang$Double == null ? (class$java$lang$Double = DataConfiguration.class$("java.lang.Double")) : class$java$lang$Double, key, defaultValue);
    }

    public double[] getDoubleArray(String key) {
        return this.getDoubleArray(key, new double[0]);
    }

    public double[] getDoubleArray(String key, double[] defaultValue) {
        return (double[])this.getArray(Double.TYPE, key, defaultValue);
    }

    public List getBigIntegerList(String key) {
        return this.getBigIntegerList(key, new ArrayList());
    }

    public List getBigIntegerList(String key, List defaultValue) {
        return this.getList(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DataConfiguration.class$("java.math.BigInteger")) : class$java$math$BigInteger, key, defaultValue);
    }

    public BigInteger[] getBigIntegerArray(String key) {
        return this.getBigIntegerArray(key, new BigInteger[0]);
    }

    public BigInteger[] getBigIntegerArray(String key, BigInteger[] defaultValue) {
        return (BigInteger[])this.getArray(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DataConfiguration.class$("java.math.BigInteger")) : class$java$math$BigInteger, key, defaultValue);
    }

    public List getBigDecimalList(String key) {
        return this.getBigDecimalList(key, new ArrayList());
    }

    public List getBigDecimalList(String key, List defaultValue) {
        return this.getList(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DataConfiguration.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, key, defaultValue);
    }

    public BigDecimal[] getBigDecimalArray(String key) {
        return this.getBigDecimalArray(key, new BigDecimal[0]);
    }

    public BigDecimal[] getBigDecimalArray(String key, BigDecimal[] defaultValue) {
        return (BigDecimal[])this.getArray(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DataConfiguration.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, key, defaultValue);
    }

    public URL getURL(String key) {
        return (URL)this.get(class$java$net$URL == null ? (class$java$net$URL = DataConfiguration.class$("java.net.URL")) : class$java$net$URL, key);
    }

    public URL getURL(String key, URL defaultValue) {
        return (URL)this.get(class$java$net$URL == null ? (class$java$net$URL = DataConfiguration.class$("java.net.URL")) : class$java$net$URL, key, defaultValue);
    }

    public List getURLList(String key) {
        return this.getURLList(key, new ArrayList());
    }

    public List getURLList(String key, List defaultValue) {
        return this.getList(class$java$net$URL == null ? (class$java$net$URL = DataConfiguration.class$("java.net.URL")) : class$java$net$URL, key, defaultValue);
    }

    public URL[] getURLArray(String key) {
        return this.getURLArray(key, new URL[0]);
    }

    public URL[] getURLArray(String key, URL[] defaultValue) {
        return (URL[])this.getArray(class$java$net$URL == null ? (class$java$net$URL = DataConfiguration.class$("java.net.URL")) : class$java$net$URL, key, defaultValue);
    }

    public Date getDate(String key) {
        return (Date)this.get(class$java$util$Date == null ? (class$java$util$Date = DataConfiguration.class$("java.util.Date")) : class$java$util$Date, key);
    }

    public Date getDate(String key, String format) {
        Date value = this.getDate(key, null, format);
        if (value != null) {
            return value;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public Date getDate(String key, Date defaultValue) {
        return this.getDate(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date getDate(String key, Date defaultValue, String format) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDate(this.interpolate(value), format);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Date", e);
        }
    }

    public List getDateList(String key) {
        return this.getDateList(key, new ArrayList());
    }

    public List getDateList(String key, String format) {
        return this.getDateList(key, new ArrayList(), format);
    }

    public List getDateList(String key, List defaultValue) {
        return this.getDateList(key, defaultValue, this.getDefaultDateFormat());
    }

    /*
     * WARNING - void declaration
     */
    public List getDateList(String key, List defaultValue, String format) {
        void var5_5;
        ArrayList<Date> list;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)value)) {
            list = defaultValue;
        } else if (value.getClass().isArray()) {
            list = new ArrayList<Date>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                list.add(PropertyConverter.toDate(this.interpolate(Array.get(value, i)), format));
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toDate(this.interpolate(it.next()), format));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toDate(this.interpolate(value), format));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Dates", e);
            }
        }
        return var5_5;
    }

    public Date[] getDateArray(String key) {
        return this.getDateArray(key, new Date[0]);
    }

    public Date[] getDateArray(String key, String format) {
        return this.getDateArray(key, new Date[0], format);
    }

    public Date[] getDateArray(String key, Date[] defaultValue) {
        return this.getDateArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date[] getDateArray(String key, Date[] defaultValue, String format) {
        List list = this.getDateList(key, format);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Date[list.size()]);
    }

    public Calendar getCalendar(String key) {
        return (Calendar)this.get(class$java$util$Calendar == null ? (class$java$util$Calendar = DataConfiguration.class$("java.util.Calendar")) : class$java$util$Calendar, key);
    }

    public Calendar getCalendar(String key, String format) {
        Calendar value = this.getCalendar(key, null, format);
        if (value != null) {
            return value;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public Calendar getCalendar(String key, Calendar defaultValue) {
        return this.getCalendar(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar getCalendar(String key, Calendar defaultValue, String format) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toCalendar(this.interpolate(value), format);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Calendar", e);
        }
    }

    public List getCalendarList(String key) {
        return this.getCalendarList(key, new ArrayList());
    }

    public List getCalendarList(String key, String format) {
        return this.getCalendarList(key, new ArrayList(), format);
    }

    public List getCalendarList(String key, List defaultValue) {
        return this.getCalendarList(key, defaultValue, this.getDefaultDateFormat());
    }

    /*
     * WARNING - void declaration
     */
    public List getCalendarList(String key, List defaultValue, String format) {
        void var5_5;
        ArrayList<Calendar> list;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)value)) {
            list = defaultValue;
        } else if (value.getClass().isArray()) {
            list = new ArrayList<Calendar>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                list.add(PropertyConverter.toCalendar(this.interpolate(Array.get(value, i)), format));
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toCalendar(this.interpolate(it.next()), format));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toCalendar(this.interpolate(value), format));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Calendars", e);
            }
        }
        return var5_5;
    }

    public Calendar[] getCalendarArray(String key) {
        return this.getCalendarArray(key, new Calendar[0]);
    }

    public Calendar[] getCalendarArray(String key, String format) {
        return this.getCalendarArray(key, new Calendar[0], format);
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue) {
        return this.getCalendarArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue, String format) {
        List list = this.getCalendarList(key, format);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Calendar[list.size()]);
    }

    private String getDefaultDateFormat() {
        return this.getString(DATE_FORMAT_KEY, DEFAULT_DATE_FORMAT);
    }

    public Locale getLocale(String key) {
        return (Locale)this.get(class$java$util$Locale == null ? (class$java$util$Locale = DataConfiguration.class$("java.util.Locale")) : class$java$util$Locale, key);
    }

    public Locale getLocale(String key, Locale defaultValue) {
        return (Locale)this.get(class$java$util$Locale == null ? (class$java$util$Locale = DataConfiguration.class$("java.util.Locale")) : class$java$util$Locale, key, defaultValue);
    }

    public List getLocaleList(String key) {
        return this.getLocaleList(key, new ArrayList());
    }

    public List getLocaleList(String key, List defaultValue) {
        return this.getList(class$java$util$Locale == null ? (class$java$util$Locale = DataConfiguration.class$("java.util.Locale")) : class$java$util$Locale, key, defaultValue);
    }

    public Locale[] getLocaleArray(String key) {
        return this.getLocaleArray(key, new Locale[0]);
    }

    public Locale[] getLocaleArray(String key, Locale[] defaultValue) {
        return (Locale[])this.getArray(class$java$util$Locale == null ? (class$java$util$Locale = DataConfiguration.class$("java.util.Locale")) : class$java$util$Locale, key, defaultValue);
    }

    public Color getColor(String key) {
        return (Color)this.get(class$java$awt$Color == null ? (class$java$awt$Color = DataConfiguration.class$("java.awt.Color")) : class$java$awt$Color, key);
    }

    public Color getColor(String key, Color defaultValue) {
        return (Color)this.get(class$java$awt$Color == null ? (class$java$awt$Color = DataConfiguration.class$("java.awt.Color")) : class$java$awt$Color, key, defaultValue);
    }

    public List getColorList(String key) {
        return this.getColorList(key, new ArrayList());
    }

    public List getColorList(String key, List defaultValue) {
        return this.getList(class$java$awt$Color == null ? (class$java$awt$Color = DataConfiguration.class$("java.awt.Color")) : class$java$awt$Color, key, defaultValue);
    }

    public Color[] getColorArray(String key) {
        return this.getColorArray(key, new Color[0]);
    }

    public Color[] getColorArray(String key, Color[] defaultValue) {
        return (Color[])this.getArray(class$java$awt$Color == null ? (class$java$awt$Color = DataConfiguration.class$("java.awt.Color")) : class$java$awt$Color, key, defaultValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

