/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.base.Throwables;
import io.prestosql.hadoop.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.ZKFCRpcServer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public abstract class ZKFailoverController {
    static final Log LOG = LogFactory.getLog(ZKFailoverController.class);
    public static final String ZK_QUORUM_KEY = "ha.zookeeper.quorum";
    private static final String ZK_SESSION_TIMEOUT_KEY = "ha.zookeeper.session-timeout.ms";
    private static final int ZK_SESSION_TIMEOUT_DEFAULT = 5000;
    private static final String ZK_PARENT_ZNODE_KEY = "ha.zookeeper.parent-znode";
    public static final String ZK_ACL_KEY = "ha.zookeeper.acl";
    private static final String ZK_ACL_DEFAULT = "world:anyone:rwcda";
    public static final String ZK_AUTH_KEY = "ha.zookeeper.auth";
    static final String ZK_PARENT_ZNODE_DEFAULT = "/hadoop-ha";
    protected static final String[] ZKFC_CONF_KEYS = new String[]{"ha.zookeeper.quorum", "ha.zookeeper.session-timeout.ms", "ha.zookeeper.parent-znode", "ha.zookeeper.acl", "ha.zookeeper.auth"};
    protected static final String USAGE = "Usage: java zkfc [ -formatZK [-force] [-nonInteractive] ]";
    static final int ERR_CODE_FORMAT_DENIED = 2;
    static final int ERR_CODE_NO_PARENT_ZNODE = 3;
    static final int ERR_CODE_NO_FENCER = 4;
    static final int ERR_CODE_AUTO_FAILOVER_NOT_ENABLED = 5;
    static final int ERR_CODE_NO_ZK = 6;
    protected Configuration conf;
    private String zkQuorum;
    protected final HAServiceTarget localTarget;
    private HealthMonitor healthMonitor;
    private ActiveStandbyElector elector;
    protected ZKFCRpcServer rpcServer;
    private HealthMonitor.State lastHealthState = HealthMonitor.State.INITIALIZING;
    private volatile HAServiceProtocol.HAServiceState serviceState = HAServiceProtocol.HAServiceState.INITIALIZING;
    private String fatalError = null;
    private long delayJoiningUntilNanotime = 0L;
    private ScheduledExecutorService delayExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ZKFC Delay timer #%d").build());
    private ActiveAttemptRecord lastActiveAttemptRecord;
    private Object activeAttemptRecordLock = new Object();
    int serviceStateMismatchCount = 0;
    boolean quitElectionOnBadState = false;

    protected ZKFailoverController(Configuration conf, HAServiceTarget localTarget) {
        this.localTarget = localTarget;
        this.conf = conf;
    }

    protected abstract byte[] targetToData(HAServiceTarget var1);

    protected abstract HAServiceTarget dataToTarget(byte[] var1);

    protected abstract void loginAsFCUser() throws IOException;

    protected abstract void checkRpcAdminAccess() throws AccessControlException, IOException;

    protected abstract InetSocketAddress getRpcAddressToBindTo();

    protected abstract PolicyProvider getPolicyProvider();

    protected abstract String getScopeInsideParentNode();

    public HAServiceTarget getLocalTarget() {
        return this.localTarget;
    }

    HAServiceProtocol.HAServiceState getServiceState() {
        return this.serviceState;
    }

    public int run(final String[] args) throws Exception {
        if (!this.localTarget.isAutoFailoverEnabled()) {
            LOG.fatal("Automatic failover is not enabled for " + this.localTarget + "." + " Please ensure that automatic failover is enabled in the " + "configuration before running the ZK failover controller.");
            return 5;
        }
        this.loginAsFCUser();
        try {
            return SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        Integer n = ZKFailoverController.this.doRun(args);
                        return n;
                    }
                    catch (Exception t) {
                        throw new RuntimeException(t);
                    }
                    finally {
                        if (ZKFailoverController.this.elector != null) {
                            ZKFailoverController.this.elector.terminateConnection();
                        }
                    }
                }
            });
        }
        catch (RuntimeException rte) {
            throw (Exception)rte.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRun(String[] args) throws HadoopIllegalArgumentException, IOException, InterruptedException {
        try {
            this.initZK();
        }
        catch (KeeperException ke) {
            LOG.fatal("Unable to start failover controller. Unable to connect to ZooKeeper quorum at " + this.zkQuorum + ". Please check the " + "configured value for " + ZK_QUORUM_KEY + " and ensure that " + "ZooKeeper is running.");
            return 6;
        }
        if (args.length > 0) {
            if ("-formatZK".equals(args[0])) {
                boolean force = false;
                boolean interactive = true;
                for (int i = 1; i < args.length; ++i) {
                    if ("-force".equals(args[i])) {
                        force = true;
                        continue;
                    }
                    if ("-nonInteractive".equals(args[i])) {
                        interactive = false;
                        continue;
                    }
                    this.badArg(args[i]);
                }
                return this.formatZK(force, interactive);
            }
            this.badArg(args[0]);
        }
        if (!this.elector.parentZNodeExists()) {
            LOG.fatal("Unable to start failover controller. Parent znode does not exist.\nRun with -formatZK flag to initialize ZooKeeper.");
            return 3;
        }
        try {
            this.localTarget.checkFencingConfigured();
        }
        catch (BadFencingConfigurationException e) {
            LOG.fatal("Fencing is not configured for " + this.localTarget + ".\n" + "You must configure a fencing method before using automatic " + "failover.", e);
            return 4;
        }
        this.initRPC();
        this.initHM();
        this.startRPC();
        try {
            this.mainLoop();
        }
        finally {
            this.rpcServer.stopAndJoin();
            this.elector.quitElection(true);
            this.healthMonitor.shutdown();
            this.healthMonitor.join();
        }
        return 0;
    }

    private void badArg(String arg) {
        this.printUsage();
        throw new HadoopIllegalArgumentException("Bad argument: " + arg);
    }

    private void printUsage() {
        System.err.println("Usage: java zkfc [ -formatZK [-force] [-nonInteractive] ]\n");
    }

    private int formatZK(boolean force, boolean interactive) throws IOException, InterruptedException {
        if (this.elector.parentZNodeExists()) {
            if (!(force || interactive && this.confirmFormat())) {
                return 2;
            }
            try {
                this.elector.clearParentZNode();
            }
            catch (IOException e) {
                LOG.error("Unable to clear zk parent znode", e);
                return 1;
            }
        }
        this.elector.ensureParentZNode();
        return 0;
    }

    private boolean confirmFormat() {
        String parentZnode = this.getParentZnode();
        System.err.println("===============================================\nThe configured parent znode " + parentZnode + " already exists.\n" + "Are you sure you want to clear all failover information from\n" + "ZooKeeper?\n" + "WARNING: Before proceeding, ensure that all HDFS services and\n" + "failover controllers are stopped!\n" + "===============================================");
        try {
            return ToolRunner.confirmPrompt("Proceed formatting " + parentZnode + "?");
        }
        catch (IOException e) {
            LOG.debug("Failed to confirm", e);
            return false;
        }
    }

    private void initHM() {
        this.healthMonitor = new HealthMonitor(this.conf, this.localTarget);
        this.healthMonitor.addCallback(new HealthCallbacks());
        this.healthMonitor.addServiceStateCallback(new ServiceStateCallBacks());
        this.healthMonitor.start();
    }

    protected void initRPC() throws IOException {
        InetSocketAddress bindAddr = this.getRpcAddressToBindTo();
        this.rpcServer = new ZKFCRpcServer(this.conf, bindAddr, this, this.getPolicyProvider());
    }

    protected void startRPC() throws IOException {
        this.rpcServer.start();
    }

    private void initZK() throws HadoopIllegalArgumentException, IOException, KeeperException {
        this.zkQuorum = this.conf.get(ZK_QUORUM_KEY);
        int zkTimeout = this.conf.getInt(ZK_SESSION_TIMEOUT_KEY, 5000);
        String zkAclConf = this.conf.get(ZK_ACL_KEY, ZK_ACL_DEFAULT);
        ArrayList zkAcls = ZKUtil.parseACLs(zkAclConf = ZKUtil.resolveConfIndirection(zkAclConf));
        if (zkAcls.isEmpty()) {
            zkAcls = ZooDefs.Ids.CREATOR_ALL_ACL;
        }
        String zkAuthConf = this.conf.get(ZK_AUTH_KEY);
        List<ZKUtil.ZKAuthInfo> zkAuths = (zkAuthConf = ZKUtil.resolveConfIndirection(zkAuthConf)) != null ? ZKUtil.parseAuth(zkAuthConf) : Collections.emptyList();
        Preconditions.checkArgument(this.zkQuorum != null, "Missing required configuration '%s' for ZooKeeper quorum", ZK_QUORUM_KEY);
        Preconditions.checkArgument(zkTimeout > 0, "Invalid ZK session timeout %s", zkTimeout);
        int maxRetryNum = this.conf.getInt("ha.failover-controller.active-standby-elector.zk.op.retries", 3);
        this.elector = new ActiveStandbyElector(this.zkQuorum, zkTimeout, this.getParentZnode(), zkAcls, zkAuths, new ElectorCallbacks(), maxRetryNum);
    }

    private String getParentZnode() {
        String znode = this.conf.get(ZK_PARENT_ZNODE_KEY, ZK_PARENT_ZNODE_DEFAULT);
        if (!znode.endsWith("/")) {
            znode = znode + "/";
        }
        return znode + this.getScopeInsideParentNode();
    }

    private synchronized void mainLoop() throws InterruptedException {
        while (this.fatalError == null) {
            this.wait();
        }
        assert (this.fatalError != null);
        throw new RuntimeException("ZK Failover Controller failed: " + this.fatalError);
    }

    private synchronized void fatalError(String err) {
        LOG.fatal("Fatal error occurred:" + err);
        this.fatalError = err;
        this.notifyAll();
    }

    private synchronized void becomeActive() throws ServiceFailedException {
        LOG.info("Trying to make " + this.localTarget + " active...");
        try {
            HAServiceProtocolHelper.transitionToActive(this.localTarget.getProxy(this.conf, FailoverController.getRpcTimeoutToNewActive(this.conf)), this.createReqInfo());
            String msg = "Successfully transitioned " + this.localTarget + " to active state";
            LOG.info(msg);
            this.serviceState = HAServiceProtocol.HAServiceState.ACTIVE;
            this.recordActiveAttempt(new ActiveAttemptRecord(true, msg));
        }
        catch (Throwable t) {
            String msg = "Couldn't make " + this.localTarget + " active";
            LOG.fatal(msg, t);
            this.recordActiveAttempt(new ActiveAttemptRecord(false, msg + "\n" + StringUtils.stringifyException(t)));
            if (t instanceof ServiceFailedException) {
                throw (ServiceFailedException)t;
            }
            throw new ServiceFailedException("Couldn't transition to active", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordActiveAttempt(ActiveAttemptRecord record) {
        Object object = this.activeAttemptRecordLock;
        synchronized (object) {
            this.lastActiveAttemptRecord = record;
            this.activeAttemptRecordLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveAttemptRecord waitForActiveAttempt(int timeoutMillis) throws InterruptedException {
        long st = System.nanoTime();
        long waitUntil = st + TimeUnit.NANOSECONDS.convert(timeoutMillis, TimeUnit.MILLISECONDS);
        do {
            Object object = this;
            synchronized (object) {
                if (this.lastHealthState != HealthMonitor.State.SERVICE_HEALTHY) {
                    return null;
                }
            }
            object = this.activeAttemptRecordLock;
            synchronized (object) {
                if (this.lastActiveAttemptRecord != null && this.lastActiveAttemptRecord.nanoTime >= st) {
                    return this.lastActiveAttemptRecord;
                }
                this.activeAttemptRecordLock.wait(1000L);
            }
        } while (System.nanoTime() < waitUntil);
        LOG.warn(timeoutMillis + "ms timeout elapsed waiting for an attempt " + "to become active");
        return null;
    }

    private HAServiceProtocol.StateChangeRequestInfo createReqInfo() {
        return new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC);
    }

    private synchronized void becomeStandby() {
        LOG.info("ZK Election indicated that " + this.localTarget + " should become standby");
        try {
            int timeout = FailoverController.getGracefulFenceTimeout(this.conf);
            this.localTarget.getProxy(this.conf, timeout).transitionToStandby(this.createReqInfo());
            LOG.info("Successfully transitioned " + this.localTarget + " to standby state");
        }
        catch (Exception e) {
            LOG.error("Couldn't transition " + this.localTarget + " to standby state", e);
        }
        this.serviceState = HAServiceProtocol.HAServiceState.STANDBY;
    }

    private synchronized void fenceOldActive(byte[] data) {
        HAServiceTarget target = this.dataToTarget(data);
        try {
            this.doFence(target);
        }
        catch (Throwable t) {
            this.recordActiveAttempt(new ActiveAttemptRecord(false, "Unable to fence old active: " + StringUtils.stringifyException(t)));
            Throwables.propagate(t);
        }
    }

    private void doFence(HAServiceTarget target) {
        LOG.info("Should fence: " + target);
        boolean gracefulWorked = new FailoverController(this.conf, HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC).tryGracefulFence(target);
        if (gracefulWorked) {
            LOG.info("Successfully transitioned " + target + " to standby " + "state without fencing");
            return;
        }
        try {
            target.checkFencingConfigured();
        }
        catch (BadFencingConfigurationException e) {
            LOG.error("Couldn't fence old active " + target, e);
            this.recordActiveAttempt(new ActiveAttemptRecord(false, "Unable to fence old active"));
            throw new RuntimeException(e);
        }
        if (!target.getFencer().fence(target)) {
            throw new RuntimeException("Unable to fence " + target);
        }
    }

    void cedeActive(final int millisToCede) throws AccessControlException, ServiceFailedException, IOException {
        try {
            UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ZKFailoverController.this.doCedeActive(millisToCede);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCedeActive(int millisToCede) throws AccessControlException, ServiceFailedException, IOException {
        int timeout = FailoverController.getGracefulFenceTimeout(this.conf);
        ActiveStandbyElector activeStandbyElector = this.elector;
        synchronized (activeStandbyElector) {
            ZKFailoverController zKFailoverController = this;
            synchronized (zKFailoverController) {
                if (millisToCede <= 0) {
                    this.delayJoiningUntilNanotime = 0L;
                    this.recheckElectability();
                    return;
                }
                LOG.info("Requested by " + UserGroupInformation.getCurrentUser() + " at " + Server.getRemoteAddress() + " to cede active role.");
                boolean needFence = false;
                try {
                    this.localTarget.getProxy(this.conf, timeout).transitionToStandby(this.createReqInfo());
                    LOG.info("Successfully ensured local node is in standby mode");
                }
                catch (IOException ioe) {
                    LOG.warn("Unable to transition local node to standby: " + ioe.getLocalizedMessage());
                    LOG.warn("Quitting election but indicating that fencing is necessary");
                    needFence = true;
                }
                this.delayJoiningUntilNanotime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(millisToCede);
                this.elector.quitElection(needFence);
                this.serviceState = HAServiceProtocol.HAServiceState.INITIALIZING;
            }
        }
        this.recheckElectability();
    }

    void gracefulFailoverToYou() throws ServiceFailedException, IOException {
        try {
            UserGroupInformation.getLoginUser().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ZKFailoverController.this.doGracefulFailover();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGracefulFailover() throws ServiceFailedException, IOException, InterruptedException {
        int timeout = FailoverController.getGracefulFenceTimeout(this.conf) * 2;
        this.checkEligibleForFailover();
        HAServiceTarget oldActive = this.getCurrentActive();
        if (oldActive == null) {
            throw new ServiceFailedException("No other node is currently active.");
        }
        if (oldActive.getAddress().equals(this.localTarget.getAddress())) {
            LOG.info("Local node " + this.localTarget + " is already active. " + "No need to failover. Returning success.");
            return;
        }
        LOG.info("Asking " + oldActive + " to cede its active state for " + timeout + "ms");
        ZKFCProtocol oldZkfc = oldActive.getZKFCProxy(this.conf, timeout);
        oldZkfc.cedeActive(timeout);
        ActiveAttemptRecord attempt = this.waitForActiveAttempt(timeout + 60000);
        if (attempt == null) {
            ZKFailoverController zKFailoverController = this;
            synchronized (zKFailoverController) {
                if (this.lastHealthState != HealthMonitor.State.SERVICE_HEALTHY) {
                    throw new ServiceFailedException("Unable to become active. Service became unhealthy while trying to failover.");
                }
            }
            throw new ServiceFailedException("Unable to become active. Local node did not get an opportunity to do so from ZooKeeper, or the local node took too long to transition to active.");
        }
        oldZkfc.cedeActive(-1);
        if (!attempt.succeeded) {
            String msg = "Failed to become active. " + attempt.status;
            throw new ServiceFailedException(msg);
        }
        LOG.info("Successfully became active. " + attempt.status);
    }

    private synchronized void checkEligibleForFailover() throws ServiceFailedException {
        if (this.getLastHealthState() != HealthMonitor.State.SERVICE_HEALTHY) {
            throw new ServiceFailedException(this.localTarget + " is not currently healthy. " + "Cannot be failover target");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HAServiceTarget getCurrentActive() throws IOException, InterruptedException {
        ActiveStandbyElector activeStandbyElector = this.elector;
        synchronized (activeStandbyElector) {
            ZKFailoverController zKFailoverController = this;
            synchronized (zKFailoverController) {
                byte[] activeData;
                try {
                    activeData = this.elector.getActiveData();
                }
                catch (ActiveStandbyElector.ActiveNotFoundException e) {
                    return null;
                }
                catch (KeeperException ke) {
                    throw new IOException("Unexpected ZooKeeper issue fetching active node info", ke);
                }
                HAServiceTarget oldActive = this.dataToTarget(activeData);
                return oldActive;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recheckElectability() {
        ActiveStandbyElector activeStandbyElector = this.elector;
        synchronized (activeStandbyElector) {
            ZKFailoverController zKFailoverController = this;
            synchronized (zKFailoverController) {
                boolean healthy = this.lastHealthState == HealthMonitor.State.SERVICE_HEALTHY;
                long remainingDelay = this.delayJoiningUntilNanotime - System.nanoTime();
                if (remainingDelay > 0L) {
                    if (healthy) {
                        LOG.info("Would have joined master election, but this node is prohibited from doing so for " + TimeUnit.NANOSECONDS.toMillis(remainingDelay) + " more ms");
                    }
                    this.scheduleRecheck(remainingDelay);
                    return;
                }
                switch (this.lastHealthState) {
                    case SERVICE_HEALTHY: {
                        this.elector.joinElection(this.targetToData(this.localTarget));
                        if (!this.quitElectionOnBadState) break;
                        this.quitElectionOnBadState = false;
                        break;
                    }
                    case INITIALIZING: {
                        LOG.info("Ensuring that " + this.localTarget + " does not " + "participate in active master election");
                        this.elector.quitElection(false);
                        this.serviceState = HAServiceProtocol.HAServiceState.INITIALIZING;
                        break;
                    }
                    case SERVICE_UNHEALTHY: 
                    case SERVICE_NOT_RESPONDING: {
                        LOG.info("Quitting master election for " + this.localTarget + " and marking that fencing is necessary");
                        this.elector.quitElection(true);
                        this.serviceState = HAServiceProtocol.HAServiceState.INITIALIZING;
                        break;
                    }
                    case HEALTH_MONITOR_FAILED: {
                        this.fatalError("Health monitor failed!");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled state:" + (Object)((Object)this.lastHealthState));
                    }
                }
            }
        }
    }

    private void scheduleRecheck(long whenNanos) {
        this.delayExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ZKFailoverController.this.recheckElectability();
                }
                catch (Throwable t) {
                    ZKFailoverController.this.fatalError("Failed to recheck electability: " + StringUtils.stringifyException(t));
                }
            }
        }, whenNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyChangedServiceState(HAServiceProtocol.HAServiceState changedState) {
        ActiveStandbyElector activeStandbyElector = this.elector;
        synchronized (activeStandbyElector) {
            ZKFailoverController zKFailoverController = this;
            synchronized (zKFailoverController) {
                if (this.serviceState == HAServiceProtocol.HAServiceState.INITIALIZING) {
                    if (this.quitElectionOnBadState) {
                        LOG.debug("rechecking for electability from bad state");
                        this.recheckElectability();
                    }
                    return;
                }
                if (changedState == this.serviceState) {
                    this.serviceStateMismatchCount = 0;
                    return;
                }
                if (this.serviceStateMismatchCount == 0) {
                    ++this.serviceStateMismatchCount;
                    return;
                }
                LOG.error("Local service " + this.localTarget + " has changed the serviceState to " + (Object)((Object)changedState) + ". Expected was " + (Object)((Object)this.serviceState) + ". Quitting election marking fencing necessary.");
                this.delayJoiningUntilNanotime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
                this.elector.quitElection(true);
                this.quitElectionOnBadState = true;
                this.serviceStateMismatchCount = 0;
                this.serviceState = HAServiceProtocol.HAServiceState.INITIALIZING;
            }
        }
    }

    @.VisibleForTesting
    synchronized HealthMonitor.State getLastHealthState() {
        return this.lastHealthState;
    }

    private synchronized void setLastHealthState(HealthMonitor.State newState) {
        LOG.info("Local service " + this.localTarget + " entered state: " + (Object)((Object)newState));
        this.lastHealthState = newState;
    }

    @.VisibleForTesting
    ActiveStandbyElector getElectorForTests() {
        return this.elector;
    }

    @.VisibleForTesting
    ZKFCRpcServer getRpcServerForTests() {
        return this.rpcServer;
    }

    private static class ActiveAttemptRecord {
        private final boolean succeeded;
        private final String status;
        private final long nanoTime;

        public ActiveAttemptRecord(boolean succeeded, String status) {
            this.succeeded = succeeded;
            this.status = status;
            this.nanoTime = System.nanoTime();
        }
    }

    class ServiceStateCallBacks
    implements HealthMonitor.ServiceStateCallback {
        ServiceStateCallBacks() {
        }

        @Override
        public void reportServiceStatus(HAServiceStatus status) {
            ZKFailoverController.this.verifyChangedServiceState(status.getState());
        }
    }

    class HealthCallbacks
    implements HealthMonitor.Callback {
        HealthCallbacks() {
        }

        @Override
        public void enteredState(HealthMonitor.State newState) {
            ZKFailoverController.this.setLastHealthState(newState);
            ZKFailoverController.this.recheckElectability();
        }
    }

    class ElectorCallbacks
    implements ActiveStandbyElector.ActiveStandbyElectorCallback {
        ElectorCallbacks() {
        }

        @Override
        public void becomeActive() throws ServiceFailedException {
            ZKFailoverController.this.becomeActive();
        }

        @Override
        public void becomeStandby() {
            ZKFailoverController.this.becomeStandby();
        }

        @Override
        public void enterNeutralMode() {
        }

        @Override
        public void notifyFatalError(String errorMessage) {
            ZKFailoverController.this.fatalError(errorMessage);
        }

        @Override
        public void fenceOldActive(byte[] data) {
            ZKFailoverController.this.fenceOldActive(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ZKFailoverController zKFailoverController = ZKFailoverController.this;
            synchronized (zKFailoverController) {
                return "Elector callbacks for " + ZKFailoverController.this.localTarget;
            }
        }
    }
}

