/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.CallOptionsUtil;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.TransportChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.internal.Headers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.tracing.ApiTracer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.tracing.BaseApiTracer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Deadline;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.org.threeten.bp.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
public final class GrpcCallContext
implements ApiCallContext {
    static final CallOptions.Key<ApiTracer> TRACER_KEY = CallOptions.Key.create("gax.tracer");
    private final Channel channel;
    private final CallOptions callOptions;
    @Nullable
    private final Duration timeout;
    @Nullable
    private final Duration streamWaitTimeout;
    @Nullable
    private final Duration streamIdleTimeout;
    @Nullable
    private final Integer channelAffinity;
    @Nullable
    private final RetrySettings retrySettings;
    @Nullable
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, CallOptions.DEFAULT, null, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, callOptions, null, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null);
    }

    private GrpcCallContext(Channel channel, CallOptions callOptions, @Nullable Duration timeout, @Nullable Duration streamWaitTimeout, @Nullable Duration streamIdleTimeout, @Nullable Integer channelAffinity, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, @Nullable RetrySettings retrySettings, @Nullable Set<StatusCode.Code> retryableCodes) {
        this.channel = channel;
        this.callOptions = Preconditions.checkNotNull(callOptions);
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.channelAffinity = channelAffinity;
        this.extraHeaders = Preconditions.checkNotNull(extraHeaders);
        this.options = Preconditions.checkNotNull(options);
        this.retrySettings = retrySettings;
        this.retryableCodes = retryableCodes == null ? null : ImmutableSet.copyOf(retryableCodes);
    }

    @Override
    public GrpcCallContext nullToSelf(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = this;
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    @Override
    public GrpcCallContext withCredentials(Credentials newCredentials) {
        Preconditions.checkNotNull(newCredentials);
        CallCredentials callCredentials = MoreCallCredentials.from(newCredentials);
        return this.withCallOptions(this.callOptions.withCallCredentials(callCredentials));
    }

    @Override
    public GrpcCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull(inputChannel);
        if (!(inputChannel instanceof GrpcTransportChannel)) {
            throw new IllegalArgumentException("Expected GrpcTransportChannel, got " + inputChannel.getClass().getName());
        }
        GrpcTransportChannel transportChannel = (GrpcTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    @Override
    public GrpcCallContext withTimeout(@Nullable Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new GrpcCallContext(this.channel, this.callOptions, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public GrpcCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument(streamWaitTimeout.compareTo(Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    @Override
    public GrpcCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument(streamIdleTimeout.compareTo(Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    @BetaApi(value="The surface for channel affinity is not stable yet and may change in the future.")
    public GrpcCallContext withChannelAffinity(@Nullable Integer affinity) {
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, affinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public GrpcCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, newExtraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    @Override
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Override
    public GrpcCallContext withRetrySettings(RetrySettings retrySettings) {
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, retrySettings, this.retryableCodes);
    }

    @Override
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public GrpcCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, retryableCodes);
    }

    @Override
    public ApiCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        Integer newChannelAffinity;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        Duration newTimeout;
        ApiTracer newTracer;
        CallCredentials newCallCredentials;
        Deadline newDeadline;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        GrpcCallContext grpcCallContext = (GrpcCallContext)inputCallContext;
        Channel newChannel = grpcCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = grpcCallContext.callOptions.getDeadline()) == null) {
            newDeadline = this.callOptions.getDeadline();
        }
        if ((newCallCredentials = grpcCallContext.callOptions.getCredentials()) == null) {
            newCallCredentials = this.callOptions.getCredentials();
        }
        if ((newTracer = grpcCallContext.callOptions.getOption(TRACER_KEY)) == null) {
            newTracer = this.callOptions.getOption(TRACER_KEY);
        }
        if ((newTimeout = grpcCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = grpcCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = grpcCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newChannelAffinity = grpcCallContext.channelAffinity) == null) {
            newChannelAffinity = this.channelAffinity;
        }
        if ((newRetrySettings = grpcCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = grpcCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, grpcCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(grpcCallContext.options);
        CallOptions newCallOptions = grpcCallContext.callOptions.withCallCredentials(newCallCredentials).withDeadline(newDeadline);
        if (newTracer != null) {
            newCallOptions = newCallOptions.withOption(TRACER_KEY, newTracer);
        }
        return new GrpcCallContext(newChannel, newCallOptions, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newChannelAffinity, newExtraHeaders, newOptions, newRetrySettings, newRetryableCodes);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    @Override
    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Override
    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    @BetaApi(value="The surface for channel affinity is not stable yet and may change in the future.")
    @Nullable
    public Integer getChannelAffinity() {
        return this.channelAffinity;
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    public GrpcCallContext withChannel(Channel newChannel) {
        return new GrpcCallContext(newChannel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    public GrpcCallContext withCallOptions(CallOptions newCallOptions) {
        return new GrpcCallContext(this.channel, newCallOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    public GrpcCallContext withRequestParamsDynamicHeaderOption(String requestParams) {
        CallOptions newCallOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(this.callOptions, requestParams);
        return this.withCallOptions(newCallOptions);
    }

    @Override
    @Nonnull
    public ApiTracer getTracer() {
        ApiTracer tracer = this.callOptions.getOption(TRACER_KEY);
        if (tracer == null) {
            tracer = BaseApiTracer.getInstance();
        }
        return tracer;
    }

    @Override
    public GrpcCallContext withTracer(@Nonnull ApiTracer tracer) {
        Preconditions.checkNotNull(tracer);
        return this.withCallOptions(this.callOptions.withOption(TRACER_KEY, tracer));
    }

    @Override
    public <T> GrpcCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new GrpcCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, newOptions, this.retrySettings, this.retryableCodes);
    }

    @Override
    public <T> T getOption(ApiCallContext.Key<T> key) {
        return this.options.getOption(key);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.streamWaitTimeout, that.streamWaitTimeout) && Objects.equals(this.streamIdleTimeout, that.streamIdleTimeout) && Objects.equals(this.channelAffinity, that.channelAffinity) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes);
    }

    Metadata getMetadata() {
        Metadata metadata = new Metadata();
        for (Map.Entry header : this.extraHeaders.entrySet()) {
            String headerKey = (String)header.getKey();
            for (String headerValue : (List)header.getValue()) {
                metadata.put(Metadata.Key.of(headerKey, Metadata.ASCII_STRING_MARSHALLER), headerValue);
            }
        }
        return metadata;
    }
}

