/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.PinotQueryBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DynamicTablePqlExtractor {
    private DynamicTablePqlExtractor() {
    }

    public static String extractPql(DynamicTable table, TupleDomain<ColumnHandle> tupleDomain) {
        Optional<String> havingClause;
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        if (!table.getProjections().isEmpty()) {
            builder.append(table.getProjections().stream().map(DynamicTablePqlExtractor::formatExpression).collect(Collectors.joining(", ")));
        }
        if (!table.getAggregateColumns().isEmpty()) {
            if (!table.getProjections().isEmpty()) {
                builder.append(", ");
            }
            builder.append(table.getAggregateColumns().stream().map(DynamicTablePqlExtractor::formatExpression).collect(Collectors.joining(", ")));
        }
        builder.append(" from ");
        builder.append(table.getTableName());
        builder.append(table.getSuffix().orElse(""));
        Optional<String> filter = DynamicTablePqlExtractor.getFilter(table.getFilter(), tupleDomain, false);
        if (filter.isPresent()) {
            builder.append(" where ").append(filter.get());
        }
        if (!table.getGroupingColumns().isEmpty()) {
            builder.append(" group by ");
            builder.append(table.getGroupingColumns().stream().map(PinotColumnHandle::getExpression).collect(Collectors.joining(", ")));
        }
        if ((havingClause = DynamicTablePqlExtractor.getFilter(table.getHavingExpression(), tupleDomain, true)).isPresent()) {
            builder.append(" having ").append(havingClause.get());
        }
        if (!table.getOrderBy().isEmpty()) {
            builder.append(" order by ").append(table.getOrderBy().stream().map(DynamicTablePqlExtractor::convertOrderByExpressionToPql).collect(Collectors.joining(", ")));
        }
        if (table.getLimit().isPresent()) {
            builder.append(" limit ");
            if (table.getOffset().isPresent()) {
                builder.append(table.getOffset().getAsLong()).append(", ");
            }
            builder.append(table.getLimit().getAsLong());
        }
        return builder.toString();
    }

    private static Optional<String> getFilter(Optional<String> filter, TupleDomain<ColumnHandle> tupleDomain, boolean forHavingClause) {
        Optional<String> tupleFilter = PinotQueryBuilder.getFilterClause(tupleDomain, Optional.empty(), forHavingClause);
        if (tupleFilter.isPresent() && filter.isPresent()) {
            return Optional.of(String.format("%s AND %s", DynamicTablePqlExtractor.encloseInParentheses(tupleFilter.get()), DynamicTablePqlExtractor.encloseInParentheses(filter.get())));
        }
        if (filter.isPresent()) {
            return filter;
        }
        if (tupleFilter.isPresent()) {
            return tupleFilter;
        }
        return Optional.empty();
    }

    private static String convertOrderByExpressionToPql(OrderByExpression orderByExpression) {
        Objects.requireNonNull(orderByExpression, "orderByExpression is null");
        StringBuilder builder = new StringBuilder().append(orderByExpression.getExpression());
        if (!orderByExpression.isAsc()) {
            builder.append(" desc");
        }
        return builder.toString();
    }

    public static String encloseInParentheses(String value) {
        return String.format("(%s)", value);
    }

    private static String formatExpression(PinotColumnHandle pinotColumnHandle) {
        if (pinotColumnHandle.isAliased()) {
            return pinotColumnHandle.getExpression() + " AS " + DynamicTablePqlExtractor.quoteIdentifier(pinotColumnHandle.getColumnName());
        }
        return pinotColumnHandle.getExpression();
    }

    public static String quoteIdentifier(String identifier) {
        return String.format("\"%s\"", identifier.replaceAll("\"", "\"\""));
    }
}

