/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.query.AggregateExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ImplementCountDistinct
implements AggregateFunctionRule<AggregateExpression, Void> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private final Function<String, String> identifierQuote;

    public ImplementCountDistinct(Function<String, String> identifierQuote) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
    }

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"count")).with(AggregateFunctionPatterns.outputType().equalTo((Object)BigintType.BIGINT)).with(AggregateFunctionPatterns.singleArgument().matching(AggregateFunctionPatterns.variable().capturedAs(ARGUMENT)));
    }

    public Optional<AggregateExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<Void> context) {
        if (!PinotSessionProperties.isCountDistinctPushdownEnabled(context.getSession())) {
            return Optional.empty();
        }
        Variable argument = (Variable)captures.get(ARGUMENT);
        Verify.verify((aggregateFunction.getOutputType() == BigintType.BIGINT ? 1 : 0) != 0);
        return Optional.of(new AggregateExpression("distinctcount", this.identifierQuote.apply(argument.getName()), false));
    }
}

