/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import io.trino.hive.$internal.com.google.common.collect.Multimap;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveConfPlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveDruidRules;

public class HiveVolcanoPlanner
extends VolcanoPlanner {
    private static final boolean ENABLE_COLLATION_TRAIT = true;
    private final boolean isHeuristic;

    public HiveVolcanoPlanner(HivePlannerContext conf) {
        super(HiveCost.FACTORY, (Context)conf);
        this.isHeuristic = conf.unwrap(HiveConfPlannerContext.class).isHeuristicMaterializationStrategy();
    }

    public static RelOptPlanner createPlanner(HivePlannerContext conf) {
        HiveVolcanoPlanner planner = new HiveVolcanoPlanner(conf);
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        return planner;
    }

    public void registerClass(RelNode node) {
        if (node instanceof DruidQuery) {
            this.addRule((RelOptRule)HiveDruidRules.FILTER);
            this.addRule((RelOptRule)HiveDruidRules.PROJECT_FILTER_TRANSPOSE);
            this.addRule((RelOptRule)HiveDruidRules.AGGREGATE_FILTER_TRANSPOSE);
            this.addRule((RelOptRule)HiveDruidRules.AGGREGATE_PROJECT);
            this.addRule((RelOptRule)HiveDruidRules.PROJECT);
            this.addRule((RelOptRule)HiveDruidRules.AGGREGATE);
            this.addRule((RelOptRule)HiveDruidRules.POST_AGGREGATION_PROJECT);
            this.addRule((RelOptRule)HiveDruidRules.FILTER_AGGREGATE_TRANSPOSE);
            this.addRule((RelOptRule)HiveDruidRules.FILTER_PROJECT_TRANSPOSE);
            this.addRule((RelOptRule)HiveDruidRules.SORT_PROJECT_TRANSPOSE);
            this.addRule((RelOptRule)HiveDruidRules.SORT);
            this.addRule((RelOptRule)HiveDruidRules.PROJECT_SORT_TRANSPOSE);
            return;
        }
        super.registerClass(node);
    }

    public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
        assert (rel != null) : "pre-condition: rel != null";
        if (rel instanceof RelSubset) {
            RelSubset subset = (RelSubset)rel;
            if (subset.getBest() != null) {
                return this.getCost(subset.getBest(), mq);
            }
            return this.costFactory.makeInfiniteCost();
        }
        if (rel.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE) == Convention.NONE) {
            return this.costFactory.makeInfiniteCost();
        }
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        if (!this.costFactory.makeZeroCost().isLt(cost)) {
            cost = this.costFactory.makeTinyCost();
        }
        boolean usesMaterializedViews = false;
        Multimap nodeTypes = mq.getNodeTypes(rel);
        for (RelNode scan : nodeTypes.get(TableScan.class)) {
            if (!((RelOptHiveTable)scan.getTable()).getHiveTableMD().isMaterializedView()) continue;
            usesMaterializedViews = true;
            break;
        }
        if (this.isHeuristic && usesMaterializedViews) {
            cost = cost.multiplyBy(1.0E-5);
            if (!this.costFactory.makeZeroCost().isLt(cost)) {
                cost = this.costFactory.makeTinyCost();
            }
            for (RelNode input : rel.getInputs()) {
                cost = cost.plus(this.getCost(input, mq));
            }
        } else {
            for (RelNode input : rel.getInputs()) {
                cost = cost.plus(this.getCost(input, mq));
            }
        }
        return cost;
    }
}

