/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.TpchEntity;
import java.util.Locale;
import java.util.Objects;

public class Customer
implements TpchEntity {
    private final long rowNumber;
    private final long customerKey;
    private final String name;
    private final String address;
    private final long nationKey;
    private final String phone;
    private final long accountBalance;
    private final String marketSegment;
    private final String comment;

    public Customer(long rowNumber, long customerKey, String name, String address, long nationKey, String phone, long accountBalance, String marketSegment, String comment) {
        this.rowNumber = rowNumber;
        this.customerKey = customerKey;
        this.name = Objects.requireNonNull(name, "name is null");
        this.address = Objects.requireNonNull(address, "address is null");
        this.nationKey = nationKey;
        this.phone = Objects.requireNonNull(phone, "phone is null");
        this.accountBalance = accountBalance;
        this.marketSegment = Objects.requireNonNull(marketSegment, "marketSegment is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getCustomerKey() {
        return this.customerKey;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getNationKey() {
        return this.nationKey;
    }

    public String getPhone() {
        return this.phone;
    }

    public double getAccountBalance() {
        return (double)this.accountBalance / 100.0;
    }

    public long getAccountBalanceInCents() {
        return this.accountBalance;
    }

    public String getMarketSegment() {
        return this.marketSegment;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|%d|%s|%s|%s|%s|", this.customerKey, this.name, this.address, this.nationKey, this.phone, GenerateUtils.formatMoney(this.accountBalance), this.marketSegment, this.comment);
    }
}

