/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.trino.tpch.GenerateUtils;
import io.trino.tpch.PartSupplier;
import io.trino.tpch.RandomBoundedInt;
import io.trino.tpch.RandomText;
import io.trino.tpch.TextPool;
import java.util.Iterator;
import java.util.Objects;

public class PartSupplierGenerator
implements Iterable<PartSupplier> {
    private static final int SUPPLIERS_PER_PART = 4;
    private static final int AVAILABLE_QUANTITY_MIN = 1;
    private static final int AVAILABLE_QUANTITY_MAX = 9999;
    private static final int SUPPLY_COST_MIN = 100;
    private static final int SUPPLY_COST_MAX = 100000;
    private static final int COMMENT_AVERAGE_LENGTH = 124;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final TextPool textPool;

    public PartSupplierGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, TextPool.getDefaultTestPool());
    }

    public PartSupplierGenerator(double scaleFactor, int part, int partCount, TextPool textPool) {
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"scaleFactor must be greater than 0");
        Preconditions.checkArgument((part >= 1 ? 1 : 0) != 0, (Object)"part must be at least 1");
        Preconditions.checkArgument((part <= partCount ? 1 : 0) != 0, (Object)"part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<PartSupplier> iterator() {
        return new PartSupplierGeneratorIterator(this.textPool, this.scaleFactor, GenerateUtils.calculateStartIndex(200000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(200000, this.scaleFactor, this.part, this.partCount));
    }

    static long selectPartSupplier(long partKey, long supplierNumber, double scaleFactor) {
        long supplierCount = (long)(10000.0 * scaleFactor);
        return (partKey + supplierNumber * (supplierCount / 4L + (partKey - 1L) / supplierCount)) % supplierCount + 1L;
    }

    private static class PartSupplierGeneratorIterator
    extends AbstractIterator<PartSupplier> {
        private final double scaleFactor;
        private final long startIndex;
        private final long rowCount;
        private final RandomBoundedInt availableQuantityRandom;
        private final RandomBoundedInt supplyCostRandom;
        private final RandomText commentRandom;
        private long index;
        private int partSupplierNumber;

        private PartSupplierGeneratorIterator(TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
            this.scaleFactor = scaleFactor;
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.availableQuantityRandom = new RandomBoundedInt(1671059989L, 1, 9999, 4);
            this.supplyCostRandom = new RandomBoundedInt(1051288424L, 100, 100000, 4);
            this.commentRandom = new RandomText(1961692154L, textPool, 124.0, 4);
            this.availableQuantityRandom.advanceRows(startIndex);
            this.supplyCostRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
        }

        protected PartSupplier computeNext() {
            if (this.index >= this.rowCount) {
                return (PartSupplier)this.endOfData();
            }
            PartSupplier partSupplier = this.makePartSupplier(this.startIndex + this.index + 1L);
            ++this.partSupplierNumber;
            if (this.partSupplierNumber >= 4) {
                this.availableQuantityRandom.rowFinished();
                this.supplyCostRandom.rowFinished();
                this.commentRandom.rowFinished();
                ++this.index;
                this.partSupplierNumber = 0;
            }
            return partSupplier;
        }

        private PartSupplier makePartSupplier(long partKey) {
            return new PartSupplier(partKey, partKey, PartSupplierGenerator.selectPartSupplier(partKey, this.partSupplierNumber, this.scaleFactor), this.availableQuantityRandom.nextValue(), this.supplyCostRandom.nextValue(), this.commentRandom.nextValue());
        }
    }
}

