/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class DefaultJdbcMetadata
implements JdbcMetadata {
    private static final String SYNTHETIC_COLUMN_NAME_PREFIX = "_pfgnrtd_";
    private final JdbcClient jdbcClient;
    private final boolean precalculateStatisticsForPushdown;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public DefaultJdbcMetadata(JdbcClient jdbcClient, boolean precalculateStatisticsForPushdown) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.precalculateStatisticsForPushdown = precalculateStatisticsForPushdown;
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.jdbcClient.schemaExists(session, schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.jdbcClient.getSchemaNames(session));
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getTableHandle(session, tableName).orElse(null);
    }

    @Override
    public JdbcTableHandle getTableHandle(ConnectorSession session, PreparedQuery preparedQuery) {
        return this.jdbcClient.getTableHandle(session, preparedQuery);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getSystemTable(session, tableName);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        Optional<Object> remainingExpression;
        TupleDomain remainingFilter;
        ImmutableList newConstraintExpressions;
        TupleDomain<ColumnHandle> oldDomain;
        TupleDomain newDomain;
        JdbcTableHandle handle = (JdbcTableHandle)table;
        if (handle.getSortOrder().isPresent() && handle.getLimit().isPresent()) {
            handle = this.flushAttributesAsQuery(session, handle);
        }
        if ((newDomain = (oldDomain = handle.getConstraint()).intersect(constraint.getSummary())).isNone()) {
            newConstraintExpressions = ImmutableList.of();
            remainingFilter = TupleDomain.all();
            remainingExpression = Optional.of(Constant.TRUE);
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            List columnHandles = (List)domains.keySet().stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            List<ColumnMapping> columnMappings = this.jdbcClient.toColumnMappings(session, (List)columnHandles.stream().map(JdbcColumnHandle::getJdbcTypeHandle).collect(ImmutableList.toImmutableList()));
            HashMap<JdbcColumnHandle, Domain> supported = new HashMap<JdbcColumnHandle, Domain>();
            HashMap<JdbcColumnHandle, Domain> unsupported = new HashMap<JdbcColumnHandle, Domain>();
            for (int i = 0; i < columnHandles.size(); ++i) {
                JdbcColumnHandle column = (JdbcColumnHandle)columnHandles.get(i);
                ColumnMapping mapping = columnMappings.get(i);
                PredicatePushdownController.DomainPushdownResult pushdownResult = mapping.getPredicatePushdownController().apply(session, (Domain)domains.get(column));
                supported.put(column, pushdownResult.getPushedDown());
                unsupported.put(column, pushdownResult.getRemainingFilter());
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
            if (JdbcMetadataSessionProperties.isComplexExpressionPushdown(session)) {
                ArrayList<String> newExpressions = new ArrayList<String>();
                ArrayList<ConnectorExpression> remainingExpressions = new ArrayList<ConnectorExpression>();
                for (ConnectorExpression expression : ConnectorExpressions.extractConjuncts((ConnectorExpression)constraint.getExpression())) {
                    Optional<String> converted = this.jdbcClient.convertPredicate(session, expression, constraint.getAssignments());
                    if (converted.isPresent()) {
                        newExpressions.add(converted.get());
                        continue;
                    }
                    remainingExpressions.add(expression);
                }
                newConstraintExpressions = ImmutableSet.builder().addAll(handle.getConstraintExpressions()).addAll(newExpressions).build().asList();
                remainingExpression = Optional.of(ConnectorExpressions.and(remainingExpressions));
            } else {
                newConstraintExpressions = ImmutableList.of();
                remainingExpression = Optional.empty();
            }
        }
        if (oldDomain.equals((Object)newDomain) && handle.getConstraintExpressions().equals(newConstraintExpressions)) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getRelationHandle(), (TupleDomain<ColumnHandle>)newDomain, (List<String>)newConstraintExpressions, handle.getSortOrder(), handle.getLimit(), handle.getColumns(), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId());
        return Optional.of(remainingExpression.isPresent() ? new ConstraintApplicationResult((Object)handle, remainingFilter, (ConnectorExpression)remainingExpression.get(), this.precalculateStatisticsForPushdown) : new ConstraintApplicationResult((Object)handle, remainingFilter, this.precalculateStatisticsForPushdown));
    }

    private JdbcTableHandle flushAttributesAsQuery(ConnectorSession session, JdbcTableHandle handle) {
        List<JdbcColumnHandle> columns = this.jdbcClient.getColumns(session, handle);
        PreparedQuery preparedQuery = this.jdbcClient.prepareQuery(session, handle, Optional.empty(), columns, (Map<String, String>)ImmutableMap.of());
        return new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<String>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.of(columns), handle.getAllReferencedTables(), handle.getNextSyntheticColumnId());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        List newColumns = (List)assignments.values().stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        if (handle.getColumns().isPresent()) {
            ImmutableSet tableColumnSet;
            ImmutableSet newColumnSet = ImmutableSet.copyOf((Collection)newColumns);
            if (newColumnSet.equals(tableColumnSet = ImmutableSet.copyOf((Collection)handle.getColumns().get()))) {
                return Optional.empty();
            }
            Verify.verify((boolean)tableColumnSet.containsAll((Collection<?>)newColumnSet), (String)"applyProjection called with columns %s and some are not available in existing query: %s", (Object)newColumnSet, (Object)tableColumnSet);
        }
        return Optional.of(new ProjectionApplicationResult((Object)new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getConstraintExpressions(), handle.getSortOrder(), handle.getLimit(), Optional.of(newColumns), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId()), projections, (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((JdbcColumnHandle)assignment.getValue()).getColumnType())).collect(ImmutableList.toImmutableList()), this.precalculateStatisticsForPushdown));
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        if (!JdbcMetadataSessionProperties.isAggregationPushdownEnabled(session)) {
            return Optional.empty();
        }
        JdbcTableHandle handle = (JdbcTableHandle)table;
        Verify.verify((!groupingSets.isEmpty() ? 1 : 0) != 0, (String)"No grouping sets provided", (Object[])new Object[0]);
        Verify.verify((!aggregates.isEmpty() || !groupingSets.equals(List.of(List.of())) ? 1 : 0) != 0, (String)"Unexpected global aggregation with no aggregate functions", (Object[])new Object[0]);
        if (!this.jdbcClient.supportsAggregationPushdown(session, handle, aggregates, assignments, groupingSets)) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent()) {
            handle = this.flushAttributesAsQuery(session, handle);
        }
        int nextSyntheticColumnId = handle.getNextSyntheticColumnId();
        ImmutableList.Builder newColumns = ImmutableList.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        ImmutableList.Builder resultAssignments = ImmutableList.builder();
        ImmutableMap.Builder expressions = ImmutableMap.builder();
        List groupingSetsAsJdbcColumnHandles = (List)groupingSets.stream().map(groupingSet -> (ImmutableList)groupingSet.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        Optional<List<JdbcColumnHandle>> tableColumns = handle.getColumns();
        groupingSetsAsJdbcColumnHandles.stream().flatMap(Collection::stream).distinct().peek(handle.getColumns().map(columns -> groupKey -> Verify.verify((boolean)columns.contains(groupKey), (String)"applyAggregation called with a grouping column %s which was not included in the table columns: %s", (Object)groupKey, (Object)tableColumns)).orElse(groupKey -> {})).forEach(arg_0 -> ((ImmutableList.Builder)newColumns).add(arg_0));
        for (AggregateFunction aggregate : aggregates) {
            Optional<JdbcExpression> expression = this.jdbcClient.implementAggregation(session, aggregate, assignments);
            if (expression.isEmpty()) {
                return Optional.empty();
            }
            String columnName = SYNTHETIC_COLUMN_NAME_PREFIX + nextSyntheticColumnId;
            ++nextSyntheticColumnId;
            JdbcColumnHandle newColumn = JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(expression.get().getJdbcTypeHandle()).setColumnType(aggregate.getOutputType()).setComment(Optional.of("synthetic")).build();
            newColumns.add((Object)newColumn);
            projections.add((Object)new Variable(newColumn.getColumnName(), aggregate.getOutputType()));
            resultAssignments.add((Object)new Assignment(newColumn.getColumnName(), (ColumnHandle)newColumn, aggregate.getOutputType()));
            expressions.put((Object)columnName, (Object)expression.get().getExpression());
        }
        ImmutableList newColumnsList = newColumns.build();
        PreparedQuery preparedQuery = this.jdbcClient.prepareQuery(session, handle, Optional.of(groupingSetsAsJdbcColumnHandles), (List<JdbcColumnHandle>)newColumnsList, (Map<String, String>)expressions.buildOrThrow());
        handle = new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<String>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.of(newColumnsList), handle.getAllReferencedTables(), nextSyntheticColumnId);
        return Optional.of(new AggregationApplicationResult((Object)handle, (List)projections.build(), (List)resultAssignments.build(), (Map)ImmutableMap.of(), this.precalculateStatisticsForPushdown));
    }

    public Optional<JoinApplicationResult<ConnectorTableHandle>> applyJoin(ConnectorSession session, JoinType joinType, ConnectorTableHandle left, ConnectorTableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        if (!JdbcMetadataSessionProperties.isJoinPushdownEnabled(session)) {
            return Optional.empty();
        }
        JdbcTableHandle leftHandle = this.flushAttributesAsQuery(session, (JdbcTableHandle)left);
        JdbcTableHandle rightHandle = this.flushAttributesAsQuery(session, (JdbcTableHandle)right);
        int nextSyntheticColumnId = Math.max(leftHandle.getNextSyntheticColumnId(), rightHandle.getNextSyntheticColumnId());
        ImmutableMap.Builder newLeftColumnsBuilder = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, leftHandle)) {
            newLeftColumnsBuilder.put((Object)column, (Object)JdbcColumnHandle.builderFrom(column).setColumnName(column.getColumnName() + "_" + nextSyntheticColumnId).build());
            ++nextSyntheticColumnId;
        }
        ImmutableMap newLeftColumns = newLeftColumnsBuilder.buildOrThrow();
        ImmutableMap.Builder newRightColumnsBuilder = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, rightHandle)) {
            newRightColumnsBuilder.put((Object)column, (Object)JdbcColumnHandle.builderFrom(column).setColumnName(column.getColumnName() + "_" + nextSyntheticColumnId).build());
            ++nextSyntheticColumnId;
        }
        ImmutableMap newRightColumns = newRightColumnsBuilder.buildOrThrow();
        ImmutableList.Builder jdbcJoinConditions = ImmutableList.builder();
        for (JoinCondition joinCondition : joinConditions) {
            Optional<JdbcColumnHandle> leftColumn = DefaultJdbcMetadata.getVariableColumnHandle(leftAssignments, joinCondition.getLeftExpression());
            Optional<JdbcColumnHandle> rightColumn = DefaultJdbcMetadata.getVariableColumnHandle(rightAssignments, joinCondition.getRightExpression());
            if (leftColumn.isEmpty() || rightColumn.isEmpty()) {
                return Optional.empty();
            }
            jdbcJoinConditions.add((Object)new JdbcJoinCondition(leftColumn.get(), joinCondition.getOperator(), rightColumn.get()));
        }
        Optional<PreparedQuery> joinQuery = this.jdbcClient.implementJoin(session, joinType, DefaultJdbcMetadata.asPreparedQuery(leftHandle), DefaultJdbcMetadata.asPreparedQuery(rightHandle), (List<JdbcJoinCondition>)jdbcJoinConditions.build(), (Map)newRightColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((JdbcColumnHandle)entry.getValue()).getColumnName())), (Map)newLeftColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((JdbcColumnHandle)entry.getValue()).getColumnName())), statistics);
        if (joinQuery.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JoinApplicationResult((Object)new JdbcTableHandle(new JdbcQueryRelationHandle(joinQuery.get()), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<String>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.of(ImmutableList.builder().addAll(newLeftColumns.values()).addAll(newRightColumns.values()).build()), leftHandle.getAllReferencedTables().flatMap(leftReferencedTables -> rightHandle.getAllReferencedTables().map(rightReferencedTables -> ImmutableSet.builder().addAll((Iterable)leftReferencedTables).addAll((Iterable)rightReferencedTables).build())), nextSyntheticColumnId), (Map)ImmutableMap.copyOf((Map)newLeftColumns), (Map)ImmutableMap.copyOf((Map)newRightColumns), this.precalculateStatisticsForPushdown));
    }

    private static Optional<JdbcColumnHandle> getVariableColumnHandle(Map<String, ColumnHandle> assignments, ConnectorExpression expression) {
        Objects.requireNonNull(assignments, "assignments is null");
        Objects.requireNonNull(expression, "expression is null");
        if (!(expression instanceof Variable)) {
            return Optional.empty();
        }
        String name = ((Variable)expression).getName();
        ColumnHandle columnHandle = assignments.get(name);
        Verify.verifyNotNull((Object)columnHandle, (String)"No assignment for %s", (Object[])new Object[]{name});
        return Optional.of((JdbcColumnHandle)columnHandle);
    }

    private static PreparedQuery asPreparedQuery(JdbcTableHandle tableHandle) {
        Preconditions.checkArgument((tableHandle.getConstraint().equals((Object)TupleDomain.all()) && tableHandle.getLimit().isEmpty() && tableHandle.getRelationHandle() instanceof JdbcQueryRelationHandle ? 1 : 0) != 0, (String)"Handle is not a plain query: %s", (Object)tableHandle);
        return ((JdbcQueryRelationHandle)tableHandle.getRelationHandle()).getPreparedQuery();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        if (limit > Integer.MAX_VALUE) {
            return Optional.empty();
        }
        if (!this.jdbcClient.supportsLimit()) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getConstraintExpressions(), handle.getSortOrder(), OptionalLong.of(limit), handle.getColumns(), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId());
        return Optional.of(new LimitApplicationResult((Object)handle, this.jdbcClient.isLimitGuaranteed(session), this.precalculateStatisticsForPushdown));
    }

    public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle table, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        if (!JdbcMetadataSessionProperties.isTopNPushdownEnabled(session)) {
            return Optional.empty();
        }
        Verify.verify((!sortItems.isEmpty() ? 1 : 0) != 0, (String)"sortItems are empty", (Object[])new Object[0]);
        JdbcTableHandle handle = (JdbcTableHandle)table;
        List resultSortOrder = (List)sortItems.stream().map(sortItem -> {
            Verify.verify((boolean)assignments.containsKey(sortItem.getName()), (String)"assignments does not contain sortItem: %s", (Object)sortItem.getName());
            return new JdbcSortItem((JdbcColumnHandle)assignments.get(sortItem.getName()), sortItem.getSortOrder());
        }).collect(ImmutableList.toImmutableList());
        if (!this.jdbcClient.supportsTopN(session, handle, resultSortOrder)) {
            return Optional.empty();
        }
        if (handle.getSortOrder().isPresent() || handle.getLimit().isPresent()) {
            if (handle.getLimit().equals(OptionalLong.of(topNCount)) && handle.getSortOrder().equals(Optional.of(resultSortOrder))) {
                return Optional.empty();
            }
            handle = this.flushAttributesAsQuery(session, handle);
        }
        JdbcTableHandle sortedTableHandle = new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getConstraintExpressions(), Optional.of(resultSortOrder), OptionalLong.of(topNCount), handle.getColumns(), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId());
        return Optional.of(new TopNApplicationResult((Object)sortedTableHandle, this.jdbcClient.isTopNGuaranteed(session), this.precalculateStatisticsForPushdown));
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Query.QueryFunctionHandle)) {
            return Optional.empty();
        }
        ConnectorTableHandle tableHandle = ((Query.QueryFunctionHandle)handle).getTableHandle();
        ConnectorTableSchema tableSchema = this.getTableSchema(session, tableHandle);
        Map<String, ColumnHandle> columnHandlesByName = this.getColumnHandles(session, tableHandle);
        List columnHandles = (List)tableSchema.getColumns().stream().map(ColumnSchema::getName).map(columnHandlesByName::get).collect(ImmutableList.toImmutableList());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, columnHandles));
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        return this.jdbcClient.getTableScanRedirection(session, tableHandle);
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableSchema(DefaultJdbcMetadata.getSchemaTableName(handle), (List)this.jdbcClient.getColumns(session, handle).stream().map(JdbcColumnHandle::getColumnSchema).collect(ImmutableList.toImmutableList()));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableMetadata(DefaultJdbcMetadata.getSchemaTableName(handle), (List)this.jdbcClient.getColumns(session, handle).stream().map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList()), this.jdbcClient.getTableProperties(session, handle), DefaultJdbcMetadata.getTableComment(handle));
    }

    public static SchemaTableName getSchemaTableName(JdbcTableHandle handle) {
        return handle.isNamedRelation() ? handle.getRequiredNamedRelation().getSchemaTableName() : new SchemaTableName("_generated", "_generated_query");
    }

    public static Optional<String> getTableComment(JdbcTableHandle handle) {
        return handle.isNamedRelation() ? handle.getRequiredNamedRelation().getComment() : Optional.empty();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.jdbcClient.getTableNames(session, schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return (Map)this.jdbcClient.getColumns(session, (JdbcTableHandle)tableHandle).stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getColumnMetadata().getName(), (Function)Functions.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        for (SchemaTableName tableName : tables) {
            try {
                this.jdbcClient.getTableHandle(session, tableName).ifPresent(tableHandle -> columns.put((Object)tableName, (Object)this.getTableMetadata(session, (ConnectorTableHandle)tableHandle).getColumns()));
            }
            catch (TableNotFoundException | AccessDeniedException throwable) {}
        }
        return columns.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JdbcColumnHandle)columnHandle).getColumnMetadata();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Verify.verify((!handle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)handle);
        this.jdbcClient.dropTable(session, handle);
    }

    private void verifyRetryMode(ConnectorSession session, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            if (!this.jdbcClient.supportsRetries()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query or task retries");
            }
            if (JdbcWriteSessionProperties.isNonTransactionalInsert(session)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Query and task retries are incompatible with non-transactional inserts");
            }
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        this.verifyRetryMode(session, retryMode);
        JdbcOutputTableHandle handle = this.jdbcClient.beginCreateTable(session, tableMetadata);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(session, handle));
        return handle;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.jdbcClient.createTable(session, tableMetadata);
    }

    private Set<Long> getSuccessfulPageSinkIds(Collection<Slice> fragments) {
        return (Set)fragments.stream().map(slice -> slice.getLong(0)).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle handle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.commitCreateTable(session, handle, this.getSuccessfulPageSinkIds(fragments));
        return Optional.empty();
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    @Override
    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        Verify.verify((!((JdbcTableHandle)tableHandle).isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.verifyRetryMode(session, retryMode);
        List columnHandles = (List)columns.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        JdbcOutputTableHandle handle = this.jdbcClient.beginInsertTable(session, (JdbcTableHandle)tableHandle, columnHandles);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(session, handle));
        return handle;
    }

    public boolean supportsMissingColumnsOnInsert() {
        return true;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle jdbcInsertHandle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.finishInsertTable(session, jdbcInsertHandle, this.getSuccessfulPageSinkIds(fragments));
        return Optional.empty();
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new JdbcColumnHandle("$update_row_id", new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), (Type)BigintType.BIGINT);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported delete");
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return this.jdbcClient.delete(session, (JdbcTableHandle)handle);
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.jdbcClient.truncateTable(session, (JdbcTableHandle)tableHandle);
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle table, Optional<String> comment) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.setTableComment(session, tableHandle, comment);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, Optional<String> comment) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.setColumnComment(session, tableHandle, columnHandle, comment);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.addColumn(session, tableHandle, columnMetadata);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.dropColumn(session, tableHandle, columnHandle);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, String target) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.renameColumn(session, tableHandle, columnHandle, target);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle table, SchemaTableName newTableName) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.renameTable(session, tableHandle, newTableName);
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle table, Map<String, Optional<Object>> properties) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.setTableProperties(session, tableHandle, properties);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        return this.jdbcClient.getTableStatistics(session, handle);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.jdbcClient.createSchema(session, schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.jdbcClient.dropSchema(session, schemaName);
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        this.jdbcClient.renameSchema(session, schemaName, newSchemaName);
    }
}

