/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.ReadFunction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public interface ObjectReadFunction
extends ReadFunction {
    @Override
    public Class<?> getJavaType();

    public Object readObject(ResultSet var1, int var2) throws SQLException;

    public static <T> ObjectReadFunction of(final Class<T> javaType, final ObjectReadFunctionImplementation<T> implementation) {
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(implementation, "implementation is null");
        return new ObjectReadFunction(){

            public Class<T> getJavaType() {
                return javaType;
            }

            public T readObject(ResultSet resultSet, int columnIndex) throws SQLException {
                return implementation.read(resultSet, columnIndex);
            }
        };
    }

    @FunctionalInterface
    public static interface ObjectReadFunctionImplementation<T> {
        public T read(ResultSet var1, int var2) throws SQLException;
    }
}

