/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.reader;

import java.util.ArrayList;
import java.util.List;

public class H3IndexResolution {
    private short _resolutions;

    public H3IndexResolution(List<Integer> resolutions) {
        for (int resolution : resolutions) {
            this._resolutions = (short)(this._resolutions | 1 << resolution);
        }
    }

    public H3IndexResolution(short resolutions) {
        this._resolutions = resolutions;
    }

    public short serialize() {
        return this._resolutions;
    }

    public int size() {
        return Integer.bitCount(this._resolutions);
    }

    public List<Integer> getResolutions() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < 15; ++i) {
            if ((this._resolutions & 1 << i) == 0) continue;
            res.add(i);
        }
        return res;
    }

    public int getLowestResolution() {
        return Integer.numberOfTrailingZeros(this._resolutions);
    }
}

